<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:wsdl20="http://www.w3.org/ns/wsdl"
	xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:sawsdl="http://www.w3.org/ns/sawsdl#"
	xmlns:hr="http://www.wsmo.org/ns/hrests#" xmlns:w11="http://schemas.xmlsoap.org/wsdl/"
	xmlns:w11soap="http://schemas.xmlsoap.org/wsdl/soap/" xmlns:w11http="http://schemas.xmlsoap.org/wsdl/http/"
	xmlns:w11mime="http://schemas.xmlsoap.org/wsdl/mime/" xmlns:soapenc11="http://schemas.xmlsoap.org/soap/encoding/"
	xmlns:soap11="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:wsdli="http://www.w3.org/ns/wsdl-instance"
	xmlns:wsdlx="http://www.w3.org/ns/wsdl-extensions" xmlns:wrpc="http://www.w3.org/ns/wsdl/rpc"
	xmlns:wsoap="http://www.w3.org/ns/wsdl/soap" xmlns:whttp="http://www.w3.org/ns/wsdl/http"

	exclude-result-prefixes='w11 w11soap w11http w11mime soap11 soapenc11
                xsd xsi wsoap whttp wrpc wsdli wsdlx'>

	<xsl:strip-space elements="*" />
	<xsl:output method="xml" media-type="text/xhtml"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
		omit-xml-declaration='yes' encoding='utf-8' indent='yes' />

	<xsl:template match="/">
		<xsl:apply-templates select='w11:definitions' />
	</xsl:template>

	<xsl:variable name='type' select='/w11:definitions/w11:binding[1]' />
	<xsl:variable name='schema' select='/w11:definitions/w11:types/xsd:schema' />
	<xsl:variable name='msgs' select='/w11:definitions/w11:message' />
	<xsl:variable name='targetNamespace' select='/w11:definitions/@targetNamespace' />
	<xsl:variable name='qname' select='resolve-QName($type/@type, $type)' />

	<xsl:template match="w11:definitions">

		<!--
			<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
			"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
		-->
		<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
			<head profile="http://www.w3.org/2003/g/data-view">
				<title>
					<xsl:value-of select="/w11:definitions/@name" />
					service API
				</title>
				<link rel="transformation" href="hrests.xslt" />
			</head>
			<body>

				<div class="service" id="{./w11:portType/@name}">
					<h1>
						<span class="label">
							<xsl:value-of select="/w11:definitions/@name" />
						</span>
						service API
					</h1>

					<xsl:variable name="op_nodes" select='./w11:portType/w11:operation' />
					<xsl:for-each select='$op_nodes'>
						<xsl:variable name='op_qname'
							select='concat($targetNamespace, concat("/" , @name))' />

						<div class="operation" id="{@name}">

							<h2>
								Operation
								<code class="label">
									<xsl:value-of select="@name" />
								</code>
							</h2>
							<p>
								Invoked using the
								<span class="method">POST</span>
								at
								<code class="address">
									<xsl:value-of select="$op_qname" />
								</code>
							</p>

							<!--
								TODO : impl pattern for the method type detection: for now not
								needed
							-->

							<xsl:variable name='ios'
								select='*[(local-name()="input" or local-name()="output" or local-name()="fault") and namespace-uri()="http://schemas.xmlsoap.org/wsdl/"]' />
							<xsl:for-each select='$ios'>
								<xsl:variable name='message_name'
									select='local-name-from-QName(resolve-QName(@message, .))' />
								<xsl:variable name='message_parts'
									select='$msgs[@name=$message_name]/w11:part' />

								<xsl:choose>

									<xsl:when test='self::w11:input'>

										<p>
											<strong>Parameters:</strong>
											<br />
											<xsl:for-each select='$message_parts'>
												<xsl:variable name='element_local_name'
													select='local-name-from-QName(resolve-QName(@type, .))' />
												<xsl:variable name='element_decl_node'
													select='$schema[1]/*[@name=$element_local_name]' />
												<xsl:variable name='modelRef'
													select='$element_decl_node[1]/@*[(local-name()="modelReference" and namespace-uri()="http://www.w3.org/ns/sawsdl")]' />
												<span class="input" id="{$element_local_name}">
													<a rel="model" href="{$modelRef}">
														<code>
															<xsl:value-of select="$element_local_name" />
														</code>
													</a>
												</span>
												<br />
											</xsl:for-each>
										</p>

									</xsl:when>

									<xsl:when test='self::w11:output'>

										<p>
											<strong>Output value(s):</strong>
											<br />
											<xsl:for-each select='$message_parts'>
												<xsl:variable name='element_local_name'
													select='local-name-from-QName(resolve-QName(@type, .))' />
												<xsl:variable name='element_decl_node'
													select='$schema[1]/*[@name=$element_local_name]' />
												<xsl:variable name='modelRef'
													select='$element_decl_node[1]/@*[(local-name()="modelReference" and namespace-uri()="http://www.w3.org/ns/sawsdl")]' />
												<span class="output" id="{$element_local_name}">
													<a rel="model" href="{$modelRef}">
														<code>
															<xsl:value-of select="$element_local_name" />
														</code>
													</a>
												</span>
												<br />
											</xsl:for-each>
										</p>

									</xsl:when>

								</xsl:choose>
							</xsl:for-each>

						</div>
					</xsl:for-each>
				</div>
			</body>
		</html>

	</xsl:template>

	<xsl:template match='w11:documentation'>

		<h2>
			<span class="label">
				<xsl:apply-templates select='*|@*|text()' />
			</span>
		</h2>

	</xsl:template>
</xsl:stylesheet>