/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.mindswap.pellet.jena.ModelExtractor;
import org.mindswap.pellet.utils.SetUtils;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletExtractInferences
extends PelletCmdApp {
    private EnumSet<ModelExtractor.StatementType> selector;

    public PelletExtractInferences(String[] args) {
        super(args);
    }

    @Override
    public String getAppId() {
        return "PelletExtractInferences: Extract a set of inferences from an ontology";
    }

    @Override
    public String getAppCmd() {
        return "pellet extract-inferences " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = new PelletCmdOptions();
        PelletCmdOption option = new PelletCmdOption("statements");
        option.setShortOption("s");
        option.setDescription("Statements to extract. The option accepts all axioms of the OWL functional syntax plus some additional ones. Valid arguments are: " + this.validStatementArguments() + ". Example: \"DirectSubClassOf DirectSubPropertyOf\"");
        option.setType("Space separated list");
        option.setDefaultValue("DefaultStatements");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        options.add(this.getLoaderOption());
        options.add(this.getInputFormatOption());
        return options;
    }

    @Override
    public void run() {
        this.mapStatementTypes();
        this.extractInferences();
    }

    public static void main(String[] args) {
        PelletExtractInferences app = new PelletExtractInferences(args);
        app.run();
    }

    private void extractInferences() {
        if (this.selector.size() == 0) {
            throw new PelletCmdException("Selector is empty, provide types to extract");
        }
        ModelExtractor extractor = new ModelExtractor(this.getKB());
        extractor.setSelector(this.selector);
        Model extracted = ModelFactory.createDefaultModel();
        if (SetUtils.intersects(this.selector, (Collection)ModelExtractor.StatementType.ALL_CLASS_STATEMENTS)) {
            extractor.extractClassModel(extracted);
        }
        if (SetUtils.intersects(this.selector, (Collection)ModelExtractor.StatementType.ALL_PROPERTY_STATEMENTS)) {
            extractor.extractPropertyModel(extracted);
        }
        if (SetUtils.intersects(this.selector, (Collection)ModelExtractor.StatementType.ALL_INDIVIDUAL_STATEMENTS)) {
            extractor.extractIndividualModel(extracted);
        }
        extracted.write((OutputStream)System.out);
    }

    private String validStatementArguments() {
        ArrayList<String> sa = new ArrayList<String>();
        sa.add("DefaultStatements");
        sa.add("AllClass");
        sa.add("AllIndividual");
        sa.add("AllProperty");
        sa.add("ClassAssertion");
        sa.add("DataPropertyAssertion");
        sa.add("DifferentIndividuals");
        sa.add("DirectClassAssertion");
        sa.add("DirectSubClassOf");
        sa.add("DirectSubPropertyOf");
        sa.add("DisjointClasses");
        sa.add("DisjointProperties");
        sa.add("EquivalentClasses");
        sa.add("EquivalentProperties");
        sa.add("InverseProperties");
        sa.add("ObjectPropertyAssertion");
        sa.add("PropertyAssertion");
        sa.add("SameIndividual");
        sa.add("SubClassOf");
        sa.add("SubPropertyOf");
        return ((Object)sa).toString();
    }

    private void mapStatementTypes() {
        String statements = this.options.getOption("statements").getValueAsString();
        String[] list = statements.split(" ");
        if (list.length == 0) {
            throw new PelletCmdException("No values for statements argument given");
        }
        for (int i = 0; i < list.length; ++i) {
            String l = list[i];
            if (l.equalsIgnoreCase("DefaultStatements")) {
                this.selectorAddAll(ModelExtractor.StatementType.DEFAULT_STATEMENTS);
                continue;
            }
            if (l.equalsIgnoreCase("AllClass")) {
                this.selectorAddAll(ModelExtractor.StatementType.ALL_CLASS_STATEMENTS);
                continue;
            }
            if (l.equalsIgnoreCase("AllIndividual")) {
                this.selectorAddAll(ModelExtractor.StatementType.ALL_INDIVIDUAL_STATEMENTS);
                continue;
            }
            if (l.equalsIgnoreCase("AllProperty")) {
                this.selectorAddAll(ModelExtractor.StatementType.ALL_PROPERTY_STATEMENTS);
                continue;
            }
            if (l.equalsIgnoreCase("ClassAssertion")) {
                this.selectorAdd(ModelExtractor.StatementType.ALL_INSTANCE);
                continue;
            }
            if (l.equalsIgnoreCase("DataPropertyAssertion")) {
                this.selectorAdd(ModelExtractor.StatementType.DATA_PROPERTY_VALUE);
                continue;
            }
            if (l.equalsIgnoreCase("DifferentIndividuals")) {
                this.selectorAdd(ModelExtractor.StatementType.DIFFERENT_FROM);
                continue;
            }
            if (l.equalsIgnoreCase("DirectClassAssertion")) {
                this.selectorAdd(ModelExtractor.StatementType.DIRECT_INSTANCE);
                continue;
            }
            if (l.equalsIgnoreCase("DirectSubClassOf")) {
                this.selectorAdd(ModelExtractor.StatementType.DIRECT_SUBCLASS);
                continue;
            }
            if (l.equalsIgnoreCase("DirectSubPropertyOf")) {
                this.selectorAdd(ModelExtractor.StatementType.DIRECT_SUBPROPERTY);
                continue;
            }
            if (l.equalsIgnoreCase("DisjointClasses")) {
                this.selectorAdd(ModelExtractor.StatementType.DISJOINT_CLASS);
                continue;
            }
            if (l.equalsIgnoreCase("DisjointProperties")) {
                this.selectorAdd(ModelExtractor.StatementType.DISJOINT_PROPERTY);
                continue;
            }
            if (l.equalsIgnoreCase("EquivalentClasses")) {
                this.selectorAdd(ModelExtractor.StatementType.EQUIVALENT_CLASS);
                continue;
            }
            if (l.equalsIgnoreCase("EquivalentProperties")) {
                this.selectorAdd(ModelExtractor.StatementType.EQUIVALENT_PROPERTY);
                continue;
            }
            if (l.equalsIgnoreCase("InverseProperties")) {
                this.selectorAdd(ModelExtractor.StatementType.INVERSE_PROPERTY);
                continue;
            }
            if (l.equalsIgnoreCase("ObjectPropertyAssertion")) {
                this.selectorAdd(ModelExtractor.StatementType.OBJECT_PROPERTY_VALUE);
                continue;
            }
            if (l.equalsIgnoreCase("PropertyAssertion")) {
                this.selectorAddAll(ModelExtractor.StatementType.PROPERTY_VALUE);
                continue;
            }
            if (l.equalsIgnoreCase("SameIndividual")) {
                this.selectorAdd(ModelExtractor.StatementType.SAME_AS);
                continue;
            }
            if (l.equalsIgnoreCase("SubClassOf")) {
                this.selectorAdd(ModelExtractor.StatementType.ALL_SUBCLASS);
                continue;
            }
            if (l.equalsIgnoreCase("SubPropertyOf")) {
                this.selectorAdd(ModelExtractor.StatementType.ALL_SUBPROPERTY);
                continue;
            }
            throw new PelletCmdException("Unknown statement type: " + l);
        }
        if (this.selector == null) {
            this.selector = ModelExtractor.StatementType.DEFAULT_STATEMENTS;
        }
    }

    private void selectorAddAll(EnumSet<ModelExtractor.StatementType> types) {
        if (this.selector == null) {
            this.selector = types;
        } else {
            this.selector.addAll(types);
        }
    }

    private void selectorAdd(ModelExtractor.StatementType type) {
        if (this.selector == null) {
            this.selector = EnumSet.of(type);
        } else {
            this.selector.add(type);
        }
    }
}

