/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.action;

import de.dailab.jiactng.agentcore.action.DoAction;
import de.dailab.jiactng.agentcore.action.Session;
import de.dailab.jiactng.agentcore.action.SessionEvent;
import de.dailab.jiactng.agentcore.ontology.IActionDescription;
import java.io.Serializable;
import java.util.Arrays;

public class ActionResult
extends SessionEvent {
    private static final long serialVersionUID = 7941825814785637285L;
    private Serializable[] results;
    private Serializable failure = null;

    public ActionResult(IActionDescription action, Session session, Serializable[] results, DoAction source) {
        super(session, action, source);
        if (results != null) {
            this.results = Arrays.copyOf(results, results.length);
        }
        if (session != null) {
            session.addToSessionHistory(this);
        }
        if (source != null && source.getMetaData() != null) {
            super.setMetaData(source.getMetaData());
        }
    }

    public ActionResult(DoAction source, Serializable[] results) {
        super(source);
        if (results != null) {
            this.results = Arrays.copyOf(results, results.length);
        }
        if (this.getSession() != null) {
            this.getSession().addToSessionHistory(this);
        }
        if (source != null && source.getMetaData() != null) {
            super.setMetaData(source.getMetaData());
        }
    }

    public ActionResult(DoAction source, Serializable failure) {
        super(source);
        if (this.getSession() != null) {
            this.getSession().addToSessionHistory(this);
        }
        if (source != null && source.getMetaData() != null) {
            super.setMetaData(source.getMetaData());
        }
        this.failure = failure;
    }

    public final Serializable[] getResults() {
        if (this.results != null) {
            return Arrays.copyOf(this.results, this.results.length);
        }
        return this.results;
    }

    public final void setResults(Serializable[] newResults) {
        this.results = newResults != null ? Arrays.copyOf(newResults, newResults.length) : null;
    }

    public final Serializable getFailure() {
        return this.failure;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ActionResult:\n results=");
        if (this.results != null) {
            builder.append(Arrays.asList(this.results).toString());
        } else {
            builder.append("null");
        }
        builder.append('\n');
        return builder.toString();
    }
}

