/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.action;

import de.dailab.jiactng.agentcore.action.SessionEvent;
import de.dailab.jiactng.agentcore.environment.ResultReceiver;
import de.dailab.jiactng.agentcore.knowledge.IFact;
import de.dailab.jiactng.agentcore.util.IdFactory;
import java.util.ArrayList;
import java.util.Calendar;

public class Session
implements IFact {
    private static final long serialVersionUID = 8699173523554827559L;
    public static final long DEFAULT_TIMETOLIVE = 60000L;
    private String sessionId;
    private Long creationTime;
    private Long timeToLive = 60000L;
    private String userToken = null;
    private String originalUser = null;
    private String originalProvider = null;
    private String originalService = null;
    private transient ResultReceiver source;
    private ArrayList<SessionEvent> history;
    private transient Integer currentCallDepth = null;

    public Session(ResultReceiver source) {
        this(IdFactory.createSessionId(source != null ? source.hashCode() : Session.class.hashCode()), System.currentTimeMillis(), source, new ArrayList<SessionEvent>());
    }

    public Session(ResultReceiver source, long timeToLive) {
        this(IdFactory.createSessionId(source != null ? source.hashCode() : Session.class.hashCode()), System.currentTimeMillis(), source, new ArrayList<SessionEvent>());
        this.timeToLive = timeToLive;
    }

    public Session() {
        this.sessionId = null;
        this.creationTime = null;
        this.history = null;
        this.source = null;
        this.timeToLive = null;
    }

    public Session(String id, Long creationTime, ResultReceiver source, ArrayList<SessionEvent> history, Long timeToLive) {
        this.sessionId = id;
        this.creationTime = creationTime;
        this.source = source;
        this.history = history;
        this.timeToLive = timeToLive != null && timeToLive > 0L ? timeToLive : null;
    }

    public Session(String id, Long creationTime, ResultReceiver source, ArrayList<SessionEvent> history) {
        this.sessionId = id;
        this.creationTime = creationTime;
        this.source = source;
        this.history = history;
    }

    public Session(Session session) {
        this.sessionId = session.getSessionId();
        this.creationTime = session.getCreationTime();
        this.source = session.getSource();
        this.history = session.getHistory();
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final void setTimeToLive(Long timeout) {
        this.timeToLive = timeout;
    }

    public final Long getTimeToLive() {
        return this.timeToLive;
    }

    public final void setSessionId(String id) {
        this.sessionId = id;
    }

    public final ResultReceiver getSource() {
        return this.source;
    }

    public final void setSource(ResultReceiver newSource) {
        this.source = newSource;
    }

    public final Long getCreationTime() {
        return this.creationTime;
    }

    public final boolean isTimeout() {
        return System.currentTimeMillis() > this.creationTime + this.timeToLive;
    }

    public final void setCreationTime(long newCreationTime) {
        this.creationTime = newCreationTime;
    }

    public final ArrayList<SessionEvent> getHistory() {
        ArrayList<SessionEvent> copy = new ArrayList<SessionEvent>();
        copy.addAll(this.history);
        return copy;
    }

    public final void addToSessionHistory(SessionEvent event) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        this.history.add(event);
    }

    public final SessionEvent removeFromSessionHistory(int index) {
        return this.history.remove(index);
    }

    public final boolean removeFromSessionHistory(SessionEvent o) {
        return this.history.remove(o);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Session:\n sessionId=");
        if (this.sessionId != null) {
            builder.append("'").append(this.sessionId).append("'");
        } else {
            builder.append("null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.creationTime != null ? this.creationTime : 0L);
        builder.append("\n created='").append(calendar.getTime().toString()).append("'");
        builder.append("\n source=");
        if (this.source != null) {
            builder.append("'").append(this.source.toString()).append("'");
        } else {
            builder.append("null");
        }
        builder.append("\n history=");
        if (this.history != null) {
            builder.append(this.history.toString());
        } else {
            builder.append("null");
        }
        builder.append('\n');
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return this.sessionId.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Session)) {
            return false;
        }
        Session other = (Session)obj;
        if (this.sessionId == null || other.sessionId == null) {
            return true;
        }
        return this.sessionId.equals(other.sessionId);
    }

    public final String getUserToken() {
        return this.userToken;
    }

    public final void setUserToken(String newUserToken) {
        this.userToken = newUserToken;
    }

    public final String getOriginalProvider() {
        return this.originalProvider;
    }

    public final void setOriginalProvider(String newOriginalProvider) {
        this.originalProvider = newOriginalProvider;
    }

    public final String getOriginalService() {
        return this.originalService;
    }

    public final void setOriginalService(String newOriginalService) {
        this.originalService = newOriginalService;
    }

    public final String getOriginalUser() {
        return this.originalUser;
    }

    public final void setOriginalUser(String newOriginalUser) {
        this.originalUser = newOriginalUser;
    }

    public final Integer getCurrentCallDepth() {
        return this.currentCallDepth;
    }

    public final void setCurrentCallDepth(int newCurrentCallDepth) {
        this.currentCallDepth = newCurrentCallDepth;
    }
}

