/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.management.jmx;

import de.dailab.jiactng.agentcore.action.DoAction;
import de.dailab.jiactng.agentcore.management.jmx.DoActionState;
import de.dailab.jiactng.agentcore.management.jmx.JmxDescriptionSupport;
import java.io.Serializable;
import java.util.Arrays;
import javax.management.Notification;

public class ActionPerformedNotification
extends Notification {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_PERFORMED = "jiactng.action.perform";
    private String actionName;
    private String agentbeanName;
    private String sessionId;
    private String owner;
    private String actionType;
    private String action;
    private Object[] actionParameters;
    private Object[] actionResult;
    private DoActionState state;
    private String originalUser;
    private String originalProvider;
    private String originalService;

    public ActionPerformedNotification(Object source, long sequenceNumber, long timeStamp, String msg, DoAction action, DoActionState state, Object[] result) {
        super(ACTION_PERFORMED, source, sequenceNumber, timeStamp, msg);
        this.actionName = action.getAction().getName();
        if (action.getAction().getProviderBean() == null) {
            System.err.println("\n-- " + action.getAction().getName() + " / " + action.getAction().getProviderBean() + " / " + (Object)((Object)state));
            this.agentbeanName = "null";
        } else {
            this.agentbeanName = action.getAction().getProviderBean().getBeanName();
        }
        this.sessionId = action.getSessionId();
        this.owner = action.getOwner();
        this.actionType = action.getAction().getClass().getSimpleName();
        this.action = action.toString();
        this.state = state;
        if (action.getSession() != null) {
            this.originalUser = action.getSession().getOriginalUser();
            this.originalProvider = action.getSession().getOriginalProvider();
            this.originalService = action.getSession().getOriginalService();
        }
        Serializable[] params = action.getParams();
        int paramSize = params.length;
        this.actionParameters = new Object[paramSize];
        for (int i = 0; i < paramSize; ++i) {
            try {
                this.actionParameters[i] = ((JmxDescriptionSupport)((Object)params[i])).getDescription();
                continue;
            }
            catch (Exception e) {
                this.actionParameters[i] = "" + params[i];
            }
        }
        if (result != null) {
            int resultSize = result.length;
            this.actionResult = new Object[resultSize];
            for (int i = 0; i < resultSize; ++i) {
                try {
                    this.actionResult[i] = ((JmxDescriptionSupport)result[i]).getDescription();
                    continue;
                }
                catch (Exception e) {
                    this.actionResult[i] = String.valueOf(result[i]);
                }
            }
        }
    }

    public final String getActionName() {
        return this.actionName;
    }

    public final String getAgentbeanName() {
        return this.agentbeanName;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final String getOwner() {
        return this.owner;
    }

    public final String getActionType() {
        return this.actionType;
    }

    public final String getAction() {
        return this.action;
    }

    public final Object[] getActionParameters() {
        return Arrays.copyOf(this.actionParameters, this.actionParameters.length);
    }

    public final Object[] getActionResult() {
        if (this.actionResult != null) {
            return Arrays.copyOf(this.actionResult, this.actionResult.length);
        }
        return this.actionResult;
    }

    public final DoActionState getState() {
        return this.state;
    }

    public final String getOriginalUser() {
        return this.originalUser;
    }

    public final String getOriginalProvider() {
        return this.originalProvider;
    }

    public final String getOriginalService() {
        return this.originalService;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ActionPerformedNotification)) {
            return false;
        }
        ActionPerformedNotification n = (ActionPerformedNotification)obj;
        if (this.source == null && n.source != null || this.source != null && !this.source.equals(n.source)) {
            return false;
        }
        if (this.actionName == null && n.actionName != null || this.actionName != null && !this.actionName.equals(n.actionName)) {
            return false;
        }
        if (this.agentbeanName == null && n.agentbeanName != null || this.agentbeanName != null && !this.agentbeanName.equals(n.agentbeanName)) {
            return false;
        }
        if (this.sessionId == null && n.sessionId != null || this.sessionId != null && !this.sessionId.equals(n.sessionId)) {
            return false;
        }
        if (this.owner == null && n.owner != null || this.owner != null && !this.owner.equals(n.owner)) {
            return false;
        }
        return (this.actionType != null || n.actionType == null) && (this.actionType == null || this.actionType.equals(n.actionType));
    }

    public int hashCode() {
        int prim = 31;
        int hash = 31 + (this.source == null ? 0 : this.source.hashCode());
        hash = 31 * hash + (this.actionName == null ? 0 : this.actionName.hashCode());
        hash = 31 * hash + (this.agentbeanName == null ? 0 : this.agentbeanName.hashCode());
        hash = 31 * hash + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        hash = 31 * hash + (this.owner == null ? 0 : this.owner.hashCode());
        hash = 31 * hash + (this.actionType == null ? 0 : this.actionType.hashCode());
        return hash;
    }
}

