/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.management.jmx;

import de.dailab.jiactng.agentcore.management.jmx.ActionPerformedNotification;
import de.dailab.jiactng.agentcore.management.jmx.DoActionState;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class ActionPerformedNotificationFilter
implements NotificationFilter {
    private static final long serialVersionUID = 1L;
    private boolean actionsEnabled = false;
    private Vector<String> actions = new Vector();
    private boolean agentbeansEnabled = false;
    private Vector<String> agentbeans = new Vector();
    private boolean invokedEnabled = true;
    private boolean startedEnabled = true;
    private boolean successEnabled = true;
    private boolean failedEnabled = true;

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        String agentbeanName;
        String actionName;
        if (!notification.getType().equals("jiactng.action.perform")) {
            return false;
        }
        DoActionState state = ((ActionPerformedNotification)notification).getState();
        if (state.equals((Object)DoActionState.invoked) && !this.invokedEnabled) {
            return false;
        }
        if (state.equals((Object)DoActionState.started) && !this.startedEnabled) {
            return false;
        }
        if (state.equals((Object)DoActionState.success) && !this.successEnabled) {
            return false;
        }
        if (state.equals((Object)DoActionState.failed) && !this.failedEnabled) {
            return false;
        }
        try {
            ActionPerformedNotification n = (ActionPerformedNotification)notification;
            actionName = n.getActionName();
            agentbeanName = n.getAgentbeanName();
        }
        catch (Exception e) {
            return false;
        }
        if (actionName == null || agentbeanName == null) {
            return false;
        }
        if (this.actionsEnabled ? !this.actions.contains(actionName) : this.actions.contains(actionName)) {
            return false;
        }
        return !(this.agentbeansEnabled ? !this.agentbeans.contains(agentbeanName) : this.agentbeans.contains(agentbeanName));
    }

    public final void enableAction(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this.actionsEnabled) {
            if (!this.actions.contains(name)) {
                this.actions.add(name);
            }
        } else {
            this.actions.remove(name);
        }
    }

    public final void disableAction(String name) {
        if (name == null) {
            return;
        }
        if (this.actionsEnabled) {
            this.actions.remove(name);
        } else if (!this.actions.contains(name)) {
            this.actions.add(name);
        }
    }

    public final void disableAllActions() {
        this.actionsEnabled = true;
        this.actions.removeAllElements();
    }

    public final void enableAgentbean(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this.agentbeansEnabled) {
            if (!this.agentbeans.contains(name)) {
                this.agentbeans.add(name);
            }
        } else {
            this.agentbeans.remove(name);
        }
    }

    public final void disableAgentbean(String name) {
        if (name == null) {
            return;
        }
        if (this.agentbeansEnabled) {
            this.agentbeans.remove(name);
        } else if (!this.agentbeans.contains(name)) {
            this.agentbeans.add(name);
        }
    }

    public final void disableAllAgentbeans() {
        this.agentbeansEnabled = true;
        this.agentbeans.removeAllElements();
    }

    public final void disableInvokedActions() {
        this.invokedEnabled = false;
    }

    public final void disableStartedActions() {
        this.startedEnabled = false;
    }

    public final void disableSuccessfulActions() {
        this.successEnabled = false;
    }

    public final void disableFailedActions() {
        this.failedEnabled = false;
    }
}

