/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.management.jmx;

import de.dailab.jiactng.agentcore.IAgent;
import de.dailab.jiactng.agentcore.IAgentBean;
import de.dailab.jiactng.agentcore.IAgentNode;
import de.dailab.jiactng.agentcore.IAgentNodeBean;
import de.dailab.jiactng.agentcore.management.Manager;
import de.dailab.jiactng.agentcore.management.jmx.JmxMulticastSender;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public final class JmxManager
implements Manager {
    public static final long MULTICAST_DELAY = 1000L;
    public static final long MULTICAST_PERIOD = 3600L;
    public static final int MULTICAST_PORT = 9999;
    public static final String MULTICAST_ADDRESS = "226.6.6.7";
    public static final String DOMAIN = "de.dailab.jiactng";
    private MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private ArrayList<JMXConnectorServer> connectorServer = new ArrayList();
    private Timer ti = null;

    @Override
    public ObjectName getMgmtNameOfAgentNode(String nodeId) throws MalformedObjectNameException {
        return new ObjectName("de.dailab.jiactng:category1=AgentNode,agentnode=" + nodeId);
    }

    @Override
    public ObjectName getMgmtNameOfAgentNodeBean(String nodeId, String beanName) throws MalformedObjectNameException {
        return new ObjectName("de.dailab.jiactng:category1=AgentNode,agentnode=" + nodeId + ",category2=agentNodeBean,agentnodebean=" + beanName);
    }

    @Override
    public ObjectName getMgmtNameOfAgentNodeResource(String nodeId, String resourceType) throws MalformedObjectNameException {
        return new ObjectName("de.dailab.jiactng:category1=AgentNode,agentnode=" + nodeId + ",category2=" + resourceType);
    }

    @Override
    public ObjectName getMgmtNameOfAgentNodeResource(String nodeId, String resourceType, String resourceName) throws MalformedObjectNameException {
        return new ObjectName("de.dailab.jiactng:category1=AgentNode,agentnode=" + nodeId + ",category2=" + resourceType + ",resource=" + resourceName);
    }

    @Override
    public ObjectName getMgmtNameOfAgent(String nodeId, String agentName) throws MalformedObjectNameException {
        return new ObjectName("de.dailab.jiactng:category1=AgentNode,agentnode=" + nodeId + ",category2=Agent,agent=" + agentName);
    }

    @Override
    public ObjectName getMgmtNameOfAgentResource(String nodeId, String agentName, String resourceType) throws MalformedObjectNameException {
        return new ObjectName("de.dailab.jiactng:category1=AgentNode,agentnode=" + nodeId + ",category2=Agent,agent=" + agentName + ",category3=" + resourceType);
    }

    @Override
    public ObjectName getMgmtNameOfAgentResource(String nodeId, String agentName, String resourceType, String resourceName) throws MalformedObjectNameException {
        return new ObjectName("de.dailab.jiactng:category1=AgentNode,agentnode=" + nodeId + ",category2=Agent,agent=" + agentName + ",category3=" + resourceType + ",resource=" + resourceName);
    }

    @Override
    public ObjectName getMgmtNameOfAgentBean(String nodeId, String agentName, String beanName) throws MalformedObjectNameException {
        return new ObjectName("de.dailab.jiactng:category1=AgentNode,agentnode=" + nodeId + ",category2=Agent,agent=" + agentName + ",category3=AgentBean,agentbean=" + beanName);
    }

    @Override
    public ObjectName getMgmtNameOfAgentBeanResource(String nodeId, String agentName, String beanName, String resourceType) throws MalformedObjectNameException {
        return new ObjectName("de.dailab.jiactng:category1=AgentNode,agentnode=" + nodeId + ",category2=Agent,agent=" + agentName + ",category3=AgentBean,agentbean=" + beanName + ",category4=" + resourceType);
    }

    @Override
    public ObjectName getMgmtNameOfAgentBeanResource(String nodeId, String agentName, String beanName, String resourceType, String resourceName) throws MalformedObjectNameException {
        return new ObjectName("de.dailab.jiactng:category1=AgentNode,agentnode=" + nodeId + ",category2=Agent,agent=" + agentName + ",category3=AgentBean,agentbean=" + beanName + ",category4=" + resourceType + ",resource=" + resourceName);
    }

    @Override
    public void registerAgentNode(IAgentNode agentNode) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName name = this.getMgmtNameOfAgentNode(agentNode.getUUID());
        this.mbs.registerMBean(agentNode, name);
    }

    @Override
    public void registerAgentNodeBean(IAgentNodeBean agentNodeBean, IAgentNode agentNode) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName name = this.getMgmtNameOfAgentNodeBean(agentNode.getUUID(), agentNodeBean.getBeanName());
        this.mbs.registerMBean(agentNodeBean, name);
    }

    @Override
    public void registerAgentNodeResource(IAgentNode node, String resourceType, Object resource) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName name = this.getMgmtNameOfAgentNodeResource(node.getUUID(), resourceType);
        this.mbs.registerMBean(resource, name);
    }

    @Override
    public void registerAgentNodeResource(IAgentNode node, String resourceType, String resourceName, Object resource) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName name = this.getMgmtNameOfAgentNodeResource(node.getUUID(), resourceType, resourceName);
        this.mbs.registerMBean(resource, name);
    }

    @Override
    public void registerAgent(IAgent agent) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName name = this.getMgmtNameOfAgent(agent.getAgentNode().getUUID(), agent.getAgentId());
        this.mbs.registerMBean(agent, name);
    }

    @Override
    public void registerAgentResource(IAgent agent, String resourceType, Object resource) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName name = this.getMgmtNameOfAgentResource(agent.getAgentNode().getUUID(), agent.getAgentId(), resourceType);
        this.mbs.registerMBean(resource, name);
    }

    @Override
    public void registerAgentResource(IAgent agent, String resourceType, String resourceName, Object resource) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName name = this.getMgmtNameOfAgentResource(agent.getAgentNode().getUUID(), agent.getAgentId(), resourceType, resourceName);
        this.mbs.registerMBean(resource, name);
    }

    @Override
    public void registerAgentBean(IAgentBean agentBean, IAgent agent) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName name = this.getMgmtNameOfAgentBean(agent.getAgentNode().getUUID(), agent.getAgentId(), agentBean.getBeanName());
        this.mbs.registerMBean(agentBean, name);
    }

    @Override
    public void registerAgentBeanResource(IAgentBean agentBean, IAgent agent, String resourceType, String resourceName, Object resource) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName name = this.getMgmtNameOfAgentBeanResource(agent.getAgentNode().getUUID(), agent.getAgentId(), agentBean.getBeanName(), resourceType, resourceName);
        this.mbs.registerMBean(resource, name);
    }

    @Override
    public void unregisterAgentNode(IAgentNode agentNode) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName name = this.getMgmtNameOfAgentNode(agentNode.getUUID());
        this.mbs.unregisterMBean(name);
    }

    @Override
    public void unregisterAgentNodeBean(IAgentNodeBean agentNodeBean, IAgentNode agentNode) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName name = this.getMgmtNameOfAgentNodeBean(agentNode.getUUID(), agentNodeBean.getBeanName());
        this.mbs.unregisterMBean(name);
    }

    @Override
    public void unregisterAgentNodeResource(IAgentNode node, String resourceType) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName name = this.getMgmtNameOfAgentNodeResource(node.getUUID(), resourceType);
        this.mbs.unregisterMBean(name);
    }

    @Override
    public void unregisterAgentNodeResource(IAgentNode node, String resourceType, String resourceName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName name = this.getMgmtNameOfAgentNodeResource(node.getUUID(), resourceType, resourceName);
        this.mbs.unregisterMBean(name);
    }

    @Override
    public void unregisterAgent(IAgent agent) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName name = this.getMgmtNameOfAgent(agent.getAgentNode().getUUID(), agent.getAgentId());
        this.mbs.unregisterMBean(name);
    }

    @Override
    public void unregisterAgentResource(IAgent agent, String resourceType) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName name = this.getMgmtNameOfAgentResource(agent.getAgentNode().getUUID(), agent.getAgentId(), resourceType);
        this.mbs.unregisterMBean(name);
    }

    @Override
    public void unregisterAgentResource(IAgent agent, String resourceType, String resourceName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName name = this.getMgmtNameOfAgentResource(agent.getAgentNode().getUUID(), agent.getAgentId(), resourceType, resourceName);
        this.mbs.unregisterMBean(name);
    }

    @Override
    public void unregisterAgentBean(IAgentBean agentBean, IAgent agent) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName name = this.getMgmtNameOfAgentBean(agent.getAgentNode().getUUID(), agent.getAgentId(), agentBean.getBeanName());
        this.mbs.unregisterMBean(name);
    }

    @Override
    public void unregisterAgentBeanResource(IAgentBean agentBean, IAgent agent, String resourceType, String resourceName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName name = this.getMgmtNameOfAgentBeanResource(agent.getAgentNode().getUUID(), agent.getAgentId(), agentBean.getBeanName(), resourceType, resourceName);
        this.mbs.unregisterMBean(name);
    }

    @Override
    public Object getAttributeOfAgentNode(String nodeID, String attributeName) throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, InstanceNotFoundException, ReflectionException {
        ObjectName name = this.getMgmtNameOfAgentNode(nodeID);
        return this.mbs.getAttribute(name, attributeName);
    }

    @Override
    public Object getAttributeOfAgentNodeBean(String nodeID, String beanName, String attributeName) throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, InstanceNotFoundException, ReflectionException {
        ObjectName name = this.getMgmtNameOfAgentNodeBean(nodeID, beanName);
        return this.mbs.getAttribute(name, attributeName);
    }

    @Override
    public Object getAttributeOfAgent(String nodeId, String agentId, String attributeName) throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, InstanceNotFoundException, ReflectionException {
        ObjectName name = this.getMgmtNameOfAgent(nodeId, agentId);
        return this.mbs.getAttribute(name, attributeName);
    }

    @Override
    public Object getAttributeOfAgentBean(String nodeId, String agentId, String beanName, String attributeName) throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, InstanceNotFoundException, ReflectionException {
        ObjectName name = this.getMgmtNameOfAgentBean(nodeId, agentId, beanName);
        return this.mbs.getAttribute(name, attributeName);
    }

    @Override
    public void setAttributeOfAgentNode(String nodeId, String attributeName, Object attributeValue) throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, InstanceNotFoundException, ReflectionException, InvalidAttributeValueException {
        ObjectName name = this.getMgmtNameOfAgentNode(nodeId);
        this.mbs.setAttribute(name, new Attribute(attributeName, attributeValue));
    }

    @Override
    public void setAttributeOfAgentNodeBean(String nodeId, String beanName, String attributeName, Object attributeValue) throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, InstanceNotFoundException, ReflectionException, InvalidAttributeValueException {
        ObjectName name = this.getMgmtNameOfAgentNodeBean(nodeId, beanName);
        this.mbs.setAttribute(name, new Attribute(attributeName, attributeValue));
    }

    @Override
    public void setAttributeOfAgent(String nodeId, String agentId, String attributeName, Object attributeValue) throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, InstanceNotFoundException, ReflectionException, InvalidAttributeValueException {
        ObjectName name = this.getMgmtNameOfAgent(nodeId, agentId);
        this.mbs.setAttribute(name, new Attribute(attributeName, attributeValue));
    }

    @Override
    public void setAttributeOfAgentBean(String nodeId, String agentId, String beanName, String attributeName, Object attributeValue) throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, InstanceNotFoundException, ReflectionException, InvalidAttributeValueException {
        ObjectName name = this.getMgmtNameOfAgentBean(nodeId, agentId, beanName);
        this.mbs.setAttribute(name, new Attribute(attributeName, attributeValue));
    }

    @Override
    public Object invokeAgentNode(String nodeId, String operationName, Object[] params, String[] signature) throws MalformedObjectNameException, MBeanException, InstanceNotFoundException, ReflectionException {
        ObjectName name = this.getMgmtNameOfAgentNode(nodeId);
        return this.mbs.invoke(name, operationName, params, signature);
    }

    @Override
    public Object invokeAgentNodeBean(String nodeId, String beanName, String operationName, Object[] params, String[] signature) throws MalformedObjectNameException, MBeanException, InstanceNotFoundException, ReflectionException {
        ObjectName name = this.getMgmtNameOfAgentNodeBean(nodeId, beanName);
        return this.mbs.invoke(name, operationName, params, signature);
    }

    @Override
    public Object invokeAgent(String nodeId, String agentId, String operationName, Object[] params, String[] signature) throws MalformedObjectNameException, MBeanException, InstanceNotFoundException, ReflectionException {
        ObjectName name = this.getMgmtNameOfAgent(nodeId, agentId);
        return this.mbs.invoke(name, operationName, params, signature);
    }

    @Override
    public Object invokeAgentBean(String nodeId, String agentId, String beanName, String operationName, Object[] params, String[] signature) throws MalformedObjectNameException, MBeanException, InstanceNotFoundException, ReflectionException {
        ObjectName name = this.getMgmtNameOfAgentBean(nodeId, agentId, beanName);
        return this.mbs.invoke(name, operationName, params, signature);
    }

    @Override
    public Set<JMXServiceURL> enableRemoteManagement(IAgentNode node) {
        Set<Map<String, Object>> jmxConnectors = node.getJmxConnectors();
        if (!jmxConnectors.isEmpty()) {
            System.setProperty("com.sun.management.jmxremote", "");
        }
        for (Map<String, Object> conf : jmxConnectors) {
            String protocol = (String)conf.get("protocol");
            if (protocol == null) {
                System.out.println("WARNING: No protocol specified for a JMX connector server");
                continue;
            }
            String portStr = (String)conf.get("port");
            int port = 0;
            if (portStr != null) {
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (Exception e) {
                    System.err.println("Port " + portStr + " of the JMX connector server for protocol " + protocol + " is not an integer. Will use 0 instead.");
                    System.err.println(e.getMessage());
                }
            }
            String path = (String)conf.get("path");
            JMXAuthenticator authenticator = (JMXAuthenticator)conf.get("authenticator");
            if (protocol.equals("rmi")) {
                String registryPort = (String)conf.get("registryPort");
                String registryHost = (String)conf.get("registryHost");
                if (registryPort != null || registryHost != null) {
                    path = "/jndi/rmi://" + (registryHost == null ? "localhost" : registryHost) + (registryPort == null ? "" : ":" + registryPort) + "/" + node.getUUID();
                }
            }
            HashMap<String, JMXAuthenticator> env = new HashMap<String, JMXAuthenticator>();
            if (authenticator != null) {
                env.put("jmx.remote.authenticator", authenticator);
            }
            JMXServiceURL jurl = null;
            try {
                jurl = new JMXServiceURL(protocol, null, port, path);
            }
            catch (Exception e) {
                System.err.println("WARNING: Unable to construct URL of JMX connector server.");
                System.err.println("It is not possible to find the local host name, or the protocol " + protocol + ", port " + port + " or path " + path + " is incorrect.");
                System.err.println(e.getMessage());
                continue;
            }
            System.out.println("Creating JMX connector server: " + jurl);
            JMXConnectorServer cs = null;
            try {
                cs = JMXConnectorServerFactory.newJMXConnectorServer(jurl, env, this.mbs);
            }
            catch (MalformedURLException e) {
                System.err.println("WARNING: Unable to create JMX connector server for " + jurl);
                System.err.println("Missing provider implementation for the specified protocol.");
                System.err.println(e.getMessage());
                continue;
            }
            catch (Exception e) {
                System.err.println("WARNING: Unable to create JMX connector server for " + jurl);
                System.err.println("Communication problem, or the found provider implementation for the specified protocol can not be used.");
                System.err.println(e.getMessage());
                continue;
            }
            try {
                cs.start();
            }
            catch (Exception e) {
                System.err.println("WARNING: Start of JMX connector server failed for " + jurl);
                String prefix = "/jndi/rmi://";
                if (path != null && path.startsWith("/jndi/rmi://")) {
                    System.err.println("Please ensure that a rmi registry is started on " + path.substring("/jndi/rmi://".length(), path.length() - node.getUUID().length() - 1));
                }
                System.err.println(e.getMessage());
                continue;
            }
            System.out.println("JMX connector server successfully started: " + cs.getAddress());
            this.connectorServer.add(cs);
            try {
                this.registerAgentNodeResource(node, "JMXConnectorServer", "\"" + cs.getAddress() + "\"", cs);
            }
            catch (Exception e) {
                System.err.println("WARNING: Unable to register JMX connector server \"" + cs.getAddress() + "\" as JMX resource.");
                System.err.println(e.getMessage());
            }
        }
        String[] jmxURLs = new String[this.connectorServer.size()];
        for (int i = 0; i < this.connectorServer.size(); ++i) {
            jmxURLs[i] = this.connectorServer.get(i).getAddress().toString();
        }
        this.ti = new Timer();
        JmxMulticastSender multiSend = new JmxMulticastSender(9999, MULTICAST_ADDRESS, 1, jmxURLs);
        this.ti.schedule((TimerTask)multiSend, 1000L, 3600L);
        System.out.println("Initiated multicast sender on port 9999 with group 226.6.6.7 and interval 3600");
        HashSet<JMXServiceURL> urls = new HashSet<JMXServiceURL>();
        for (int i = 0; i < this.connectorServer.size(); ++i) {
            urls.add(this.connectorServer.get(i).getAddress());
        }
        return urls;
    }

    @Override
    public void disableRemoteManagement(IAgentNode node) {
        if (this.ti != null) {
            this.ti.cancel();
            this.ti = null;
        }
        Iterator<JMXConnectorServer> i = this.connectorServer.iterator();
        while (i.hasNext()) {
            JMXConnectorServer cs = i.next();
            try {
                this.unregisterAgentNodeResource(node, "JMXConnectorServer", "\"" + cs.getAddress() + "\"");
            }
            catch (Exception e) {
                System.err.println("WARNING: Unable to deregister JMX connector server \"" + cs.getAddress() + "\" as JMX resource.");
                System.err.println(e.getMessage());
            }
            System.out.println("Stop connector server " + cs.getAddress().toString());
            try {
                cs.stop();
            }
            catch (Exception e) {
                System.err.println("WARNING: Unable to stop JMX connector server!");
                System.err.println(e.getMessage());
            }
            i.remove();
        }
    }
}

