/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.management.jmx;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.TimerTask;

public final class JmxMulticastSender
extends TimerTask {
    private int multicastPort;
    private String groupAddress;
    private String[] jmxURLs;
    private InetAddress group;
    private MulticastSocket socket;
    private boolean connected = true;

    public JmxMulticastSender(int port, String netaddr, int ttl, String[] jmxURLs) {
        this.multicastPort = port;
        this.groupAddress = netaddr;
        this.jmxURLs = jmxURLs;
        try {
            this.group = InetAddress.getByName(this.groupAddress);
            this.socket = new MulticastSocket(this.multicastPort);
            this.socket.setTimeToLive(ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        for (int i = 0; i < this.jmxURLs.length; ++i) {
            String message = this.jmxURLs[i];
            try {
                this.socket.joinGroup(this.group);
                if (!this.connected) {
                    System.out.println("Network connection established to send on multicast socket.");
                    this.connected = true;
                }
                byte[] buffer = message.getBytes();
                DatagramPacket dp = new DatagramPacket(buffer, buffer.length, this.group, this.multicastPort);
                this.socket.send(dp);
                this.socket.leaveGroup(this.group);
                continue;
            }
            catch (Exception e) {
                if (!this.connected) continue;
                System.err.println("Missing network connection to send on multicast socket!");
                this.connected = false;
            }
        }
    }
}

