/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.management.jmx;

import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import de.dailab.jiactng.agentcore.comm.IGroupAddress;
import de.dailab.jiactng.agentcore.comm.message.IJiacMessage;
import javax.management.Notification;

public class MessageExchangeNotification
extends Notification {
    private static final long serialVersionUID = 1L;
    public static final String MESSAGE_EXCHANGE = "jiactng.message.exchange";
    private MessageExchangeAction action;
    private String sender;
    private String receiver;
    private Object message;
    private String transport;
    private boolean groupMessage;

    public MessageExchangeNotification(Object source, long sequenceNumber, long timeStamp, String msg, MessageExchangeAction action, ICommunicationAddress receiver, IJiacMessage jiacMessage, String transport) {
        super(MESSAGE_EXCHANGE, source, sequenceNumber, timeStamp, msg);
        this.action = action;
        this.sender = jiacMessage.getSender() == null ? null : jiacMessage.getSender().getName();
        this.receiver = receiver == null ? null : receiver.getName();
        try {
            this.message = jiacMessage.getDescription();
        }
        catch (Exception e) {
            this.message = jiacMessage.toString();
        }
        this.transport = transport;
        this.groupMessage = receiver instanceof IGroupAddress;
    }

    public final MessageExchangeAction getAction() {
        return this.action;
    }

    public final String getSender() {
        return this.sender;
    }

    public final String getReceiver() {
        return this.receiver;
    }

    public final Object getJiacMessage() {
        return this.message;
    }

    public final String getTransport() {
        return this.transport;
    }

    public final boolean isGroupMessage() {
        return this.groupMessage;
    }

    public static enum MessageExchangeAction {
        SEND,
        RECEIVE;

    }
}

