/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.management.jmx.client;

import de.dailab.jiactng.agentcore.lifecycle.LifecycleException;
import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class JmxAbstractManagementClient {
    private MBeanServerConnection mbsc = null;
    private ObjectName resource = null;

    protected JmxAbstractManagementClient(MBeanServerConnection mbsc, ObjectName resource) {
        this.mbsc = mbsc;
        this.resource = resource;
    }

    protected final void changeState(String action) throws IOException, InstanceNotFoundException, LifecycleException {
        try {
            this.mbsc.invoke(this.resource, action, new Object[0], new String[0]);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            if (e.getCause() != null && e.getCause() instanceof LifecycleException) {
                throw (LifecycleException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    protected final Object getAttribute(String attributeName) throws IOException, InstanceNotFoundException {
        try {
            return this.mbsc.getAttribute(this.resource, attributeName);
        }
        catch (MBeanException e) {
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void setAttribute(String attributeName, Object attributeValue) throws IOException, InstanceNotFoundException, InvalidAttributeValueException {
        try {
            this.mbsc.setAttribute(this.resource, new Attribute(attributeName, attributeValue));
        }
        catch (MBeanException e) {
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected final Object invokeOperation(String operationName, Object[] params, String[] signature) throws IOException, InstanceNotFoundException {
        try {
            return this.mbsc.invoke(this.resource, operationName, params, signature);
        }
        catch (MBeanException e) {
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    protected final boolean isInstanceOf(String className) throws IOException, InstanceNotFoundException {
        return this.mbsc.isInstanceOf(this.resource, className);
    }

    protected final void addNotificationListener(NotificationListener listener, NotificationFilter filter) throws IOException, InstanceNotFoundException {
        this.mbsc.addNotificationListener(this.resource, listener, filter, null);
    }

    protected final void removeNotificationListener(NotificationListener listener, NotificationFilter filter) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        this.mbsc.removeNotificationListener(this.resource, listener, filter, null);
    }
}

