/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.management.jmx.client;

import de.dailab.jiactng.agentcore.lifecycle.LifecycleException;
import de.dailab.jiactng.agentcore.management.jmx.DisableLifeCycleAttributeFilter;
import de.dailab.jiactng.agentcore.management.jmx.JmxManager;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxAbstractManagementClient;
import de.dailab.jiactng.agentcore.ontology.IAgentDescription;
import java.io.IOException;
import java.util.List;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class JmxAgentManagementClient
extends JmxAbstractManagementClient {
    private static final AttributeChangeNotificationFilter AGENTNAME_NOTIFICATION_FILTER = new AttributeChangeNotificationFilter();
    private static final AttributeChangeNotificationFilter LIFECYCLE_NOTIFICATION_FILTER = new AttributeChangeNotificationFilter();
    private static final DisableLifeCycleAttributeFilter PROPERTY_NOTIFICATION_FILTER = new DisableLifeCycleAttributeFilter();

    protected JmxAgentManagementClient(MBeanServerConnection mbsc, String agentNodeID, String agentID) throws MalformedObjectNameException {
        super(mbsc, new JmxManager().getMgmtNameOfAgent(agentNodeID, agentID));
    }

    public final String getAgentState() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("LifecycleState");
    }

    public final void addLifecycleStateListener(NotificationListener listener) throws IOException, InstanceNotFoundException {
        this.addNotificationListener(listener, LIFECYCLE_NOTIFICATION_FILTER);
    }

    public final void removeLifecycleStateListener(NotificationListener listener) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(listener, LIFECYCLE_NOTIFICATION_FILTER);
    }

    public final void initAgent() throws IOException, InstanceNotFoundException, LifecycleException {
        this.changeState("init");
    }

    public final void startAgent() throws IOException, InstanceNotFoundException, LifecycleException {
        this.changeState("start");
    }

    public final void stopAgent() throws IOException, InstanceNotFoundException, LifecycleException {
        this.changeState("stop");
    }

    public final void cleanupAgent() throws IOException, InstanceNotFoundException, LifecycleException {
        this.changeState("cleanup");
    }

    public final String getAgentLogLevel() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("LogLevel");
    }

    public final void setAgentLogLevel(String level) throws IOException, InstanceNotFoundException, InvalidAttributeValueException {
        this.setAttribute("LogLevel", level);
    }

    public final CompositeData getAgentLogger() throws IOException, InstanceNotFoundException {
        return (CompositeData)this.getAttribute("Logger");
    }

    public final String getAgentName() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("AgentName");
    }

    public final void setAgentName(String agentname) throws IOException, InstanceNotFoundException, InvalidAttributeValueException {
        this.setAttribute("AgentName", agentname);
    }

    public final void addAgentNameListener(NotificationListener listener) throws IOException, InstanceNotFoundException {
        this.addNotificationListener(listener, AGENTNAME_NOTIFICATION_FILTER);
    }

    public final void removeAgentNameListener(NotificationListener listener) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(listener, AGENTNAME_NOTIFICATION_FILTER);
    }

    public final void addAgentPropertyListener(NotificationListener listener) throws IOException, InstanceNotFoundException {
        this.addNotificationListener(listener, PROPERTY_NOTIFICATION_FILTER);
    }

    public final void removeAgentPropertyListener(NotificationListener listener) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(listener, PROPERTY_NOTIFICATION_FILTER);
    }

    public final String getOwner() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("Owner");
    }

    public final void setOwner(String owner) throws IOException, InstanceNotFoundException, InvalidAttributeValueException {
        this.setAttribute("Owner", owner);
    }

    public final List<String> getAgentBeanNames() throws IOException, InstanceNotFoundException {
        return (List)this.getAttribute("AgentBeanNames");
    }

    public final List<String> getActionNames() throws IOException, InstanceNotFoundException {
        return (List)this.getAttribute("ActionNames");
    }

    public final long getBeanExecutionTimeout() throws IOException, InstanceNotFoundException {
        return (Long)this.getAttribute("BeanExecutionTimeout");
    }

    public final void setBeanExecutionTimeout(long beanExecutionTimeout) throws IOException, InstanceNotFoundException, InvalidAttributeValueException {
        this.setAttribute("BeanExecutionTimeout", beanExecutionTimeout);
    }

    public final String getExecutionCycleClass() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("ExecutionCycleClass");
    }

    public final CompositeData getMemoryData() throws IOException, InstanceNotFoundException {
        return (CompositeData)this.getAttribute("MemoryData");
    }

    public final void removeAgent() throws IOException, InstanceNotFoundException {
        this.invokeOperation("remove", new Object[0], new String[0]);
    }

    public final Long getStartTime() throws IOException, InstanceNotFoundException {
        return (Long)this.getAttribute("StartTime");
    }

    public final void setStartTime(Long startTime) throws IOException, InstanceNotFoundException, InvalidAttributeValueException {
        this.setAttribute("StartTime", startTime);
    }

    public final Long getStopTime() throws IOException, InstanceNotFoundException {
        return (Long)this.getAttribute("StopTime");
    }

    public final void setStopTime(Long stopTime) throws IOException, InstanceNotFoundException, InvalidAttributeValueException {
        this.setAttribute("StopTime", stopTime);
    }

    public final void setAutoExecutionServices(List<String> actionIds) throws IOException, InstanceNotFoundException, InvalidAttributeValueException {
        this.setAttribute("AutoExecutionServices", actionIds);
    }

    public final List<String> getAutoExecutionServices() throws IOException, InstanceNotFoundException {
        return (List)this.getAttribute("AutoExecutionServices");
    }

    public final void setAutoExecutionType(boolean continous) throws IOException, InstanceNotFoundException, InvalidAttributeValueException {
        this.setAttribute("AutoExecutionType", continous);
    }

    public final boolean getAutoExecutionType() throws IOException, InstanceNotFoundException {
        return (Boolean)this.getAttribute("AutoExecutionType");
    }

    public final byte[] getSpringConfigXml() throws IOException, InstanceNotFoundException {
        return (byte[])this.getAttribute("SpringConfigXml");
    }

    public final IAgentDescription getAgentDescription() throws InstanceNotFoundException, IOException {
        return (IAgentDescription)this.getAttribute("AgentDescription");
    }

    static {
        AGENTNAME_NOTIFICATION_FILTER.enableAttribute("AgentName");
        LIFECYCLE_NOTIFICATION_FILTER.enableAttribute("LifecycleState");
    }
}

