/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.management.jmx.client;

import de.dailab.jiactng.agentcore.lifecycle.LifecycleException;
import de.dailab.jiactng.agentcore.management.jmx.JmxManager;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxAbstractManagementClient;
import de.dailab.jiactng.agentcore.util.jar.JARMemory;
import java.io.IOException;
import java.util.List;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class JmxAgentNodeManagementClient
extends JmxAbstractManagementClient {
    private static final AttributeChangeNotificationFilter AGENTS_NOTIFICATION_FILTER = new AttributeChangeNotificationFilter();
    private static final AttributeChangeNotificationFilter LIFECYCLE_NOTIFICATION_FILTER = new AttributeChangeNotificationFilter();

    protected JmxAgentNodeManagementClient(MBeanServerConnection mbsc, String agentNodeID) throws MalformedObjectNameException {
        super(mbsc, new JmxManager().getMgmtNameOfAgentNode(agentNodeID));
    }

    public final String getAgentNodeState() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("LifecycleState");
    }

    public final void addLifecycleStateListener(NotificationListener listener) throws IOException, InstanceNotFoundException {
        this.addNotificationListener(listener, LIFECYCLE_NOTIFICATION_FILTER);
    }

    public final void removeLifecycleStateListener(NotificationListener listener) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(listener, LIFECYCLE_NOTIFICATION_FILTER);
    }

    public final void initAgentNode() throws IOException, LifecycleException, InstanceNotFoundException {
        this.changeState("init");
    }

    public final void startAgentNode() throws IOException, LifecycleException, InstanceNotFoundException {
        this.changeState("start");
    }

    public final void stopAgentNode() throws IOException, LifecycleException, InstanceNotFoundException {
        this.changeState("stop");
    }

    public final void cleanupAgentNode() throws IOException, LifecycleException, InstanceNotFoundException {
        this.changeState("cleanup");
    }

    public final String getAgentNodeLogLevel() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("LogLevel");
    }

    public final void setAgentNodeLogLevel(String level) throws IOException, InvalidAttributeValueException, InstanceNotFoundException {
        this.setAttribute("LogLevel", level);
    }

    public final CompositeData getAgentNodeLogger() throws IOException, InstanceNotFoundException {
        return (CompositeData)this.getAttribute("Logger");
    }

    public final String getAgentNodeID() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("UUID");
    }

    public final String getAgentNodeOwner() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("Owner");
    }

    public final List<String> getAgents() throws IOException, InstanceNotFoundException {
        return (List)this.getAttribute("Agents");
    }

    public final List<String> addAgents(byte[] configuration, List<JARMemory> libraries, String owner) throws IOException, InstanceNotFoundException {
        return (List)this.invokeOperation("addAgents", new Object[]{configuration, libraries, owner}, new String[]{"[B", "java.util.List", "java.lang.String"});
    }

    public final void addAgentsListener(NotificationListener listener) throws IOException, InstanceNotFoundException {
        this.addNotificationListener(listener, AGENTS_NOTIFICATION_FILTER);
    }

    public final void removeAgentsListener(NotificationListener listener) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(listener, AGENTS_NOTIFICATION_FILTER);
    }

    public final List<String> getAgentNodeBeanClasses() throws IOException, InstanceNotFoundException {
        return (List)this.getAttribute("AgentNodeBeanClasses");
    }

    public final String getDirectoryName() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("DirectoryName");
    }

    public final String getHost() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("Host");
    }

    public final String getJiacVendor() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("JiacVendor");
    }

    public final String getJiacVersion() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("JiacVersion");
    }

    public final void addLog4JSocketAppender(String address, int port) throws IOException, InstanceNotFoundException {
        this.invokeOperation("addLog4JSocketAppender", new Object[]{address, port}, new String[]{"java.lang.String", "int"});
    }

    public final void removeLog4JSocketAppender(String address, int port) throws IOException, InstanceNotFoundException {
        this.invokeOperation("removeLog4JSocketAppender", new Object[]{address, port}, new String[]{"java.lang.String", "int"});
    }

    public final String getAgentNodeName() throws IOException, InstanceNotFoundException {
        return (String)this.getAttribute("Name");
    }

    public final void setAgentNodeName(String name) throws IOException, InvalidAttributeValueException, InstanceNotFoundException {
        this.setAttribute("Name", name);
    }

    public final void shutdownAgentNode() throws IOException, InstanceNotFoundException {
        this.invokeOperation("shutdown", new Object[0], new String[0]);
    }

    static {
        AGENTS_NOTIFICATION_FILTER.enableAttribute("Agents");
        LIFECYCLE_NOTIFICATION_FILTER.enableAttribute("LifecycleState");
    }
}

