/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.management.jmx.client;

import de.dailab.jiactng.agentcore.comm.CommunicationBeanMBean;
import de.dailab.jiactng.agentcore.management.jmx.JmxManager;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxAgentBeanManagementClient;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxAgentCommunicationManagementClient;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxAgentExecutionCycleManagementClient;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxAgentManagementClient;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxAgentMemoryManagementClient;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxAgentNodeDirectoryManagementClient;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxAgentNodeManagementClient;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxAgentNodeTimerManagementClient;
import de.dailab.jiactng.agentcore.util.IdFactory;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JmxManagementClient {
    public static final long MULTICAST_RECEIVER_TIMEOUT = 5000L;
    public static final int MAX_MULTICAST_MESSAGE_LENGTH = 1000;
    protected MBeanServerConnection mbsc = null;
    private JMXConnector jmxc = null;

    public static List<JMXServiceURL> getURLsFromRegistry(String host, int port) throws RemoteException {
        ArrayList<JMXServiceURL> urls = new ArrayList<JMXServiceURL>();
        for (String nodeId : Arrays.asList(LocateRegistry.getRegistry(host, port).list())) {
            if (!nodeId.startsWith(IdFactory.IdPrefix.Node.toString())) continue;
            try {
                urls.add(new JMXServiceURL("rmi", null, 0, "/jndi/rmi://" + host + ":" + port + "/" + nodeId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return urls;
    }

    public static List<JMXServiceURL> getURLsFromMulticast() throws IOException {
        ArrayList<JMXServiceURL> urls = new ArrayList<JMXServiceURL>();
        byte[] buffer = new byte[1000];
        long endTime = System.currentTimeMillis() + 5000L;
        InetAddress group = InetAddress.getByName("226.6.6.7");
        MulticastSocket socket = new MulticastSocket(9999);
        socket.setTimeToLive(1);
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        socket.joinGroup(group);
        while (System.currentTimeMillis() < endTime) {
            dp.setLength(1000);
            socket.receive(dp);
            buffer = dp.getData();
            String message = new String(buffer, 0, dp.getLength());
            try {
                JMXServiceURL url = new JMXServiceURL(message);
                if (url.getURLPath().contains("localhost")) {
                    url = new JMXServiceURL(message.replace("localhost", url.getHost()));
                }
                if (urls.contains(url)) continue;
                urls.add(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return urls;
    }

    public JmxManagementClient() {
        System.setProperty("jmx.invoke.getters", "");
        this.mbsc = ManagementFactory.getPlatformMBeanServer();
    }

    public JmxManagementClient(JMXServiceURL url) throws IOException {
        this.jmxc = JMXConnectorFactory.connect(url);
        this.mbsc = this.jmxc.getMBeanServerConnection();
    }

    public JmxManagementClient(JMXServiceURL url, String username, String password) throws IOException {
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", new String[]{username, password});
        this.jmxc = JMXConnectorFactory.connect(url, env);
        this.mbsc = this.jmxc.getMBeanServerConnection();
    }

    public JmxManagementClient(JmxManagementClient client) {
        this.mbsc = client.mbsc;
    }

    public final void close() throws IOException {
        if (this.jmxc != null) {
            this.jmxc.close();
            this.jmxc = null;
        }
    }

    public final Set<String> getAgentNodeUUIDs() throws IOException {
        try {
            Set<ObjectName> agentNodes = this.mbsc.queryNames(new JmxManager().getMgmtNameOfAgentNode("*"), null);
            HashSet<String> agentNodeUUIDs = new HashSet<String>();
            for (ObjectName agentNode : agentNodes) {
                agentNodeUUIDs.add(agentNode.getKeyProperty("agentnode"));
            }
            return agentNodeUUIDs;
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public final JmxAgentNodeManagementClient getAgentNodeManagementClient(String agentNodeID) throws MalformedObjectNameException {
        return new JmxAgentNodeManagementClient(this.mbsc, agentNodeID);
    }

    public final JmxAgentNodeTimerManagementClient getAgentNodeTimerManagementClient(String agentNodeID) throws MalformedObjectNameException {
        return new JmxAgentNodeTimerManagementClient(this.mbsc, agentNodeID);
    }

    public final JmxAgentManagementClient getAgentManagementClient(String agentNodeID, String agentID) throws MalformedObjectNameException {
        return new JmxAgentManagementClient(this.mbsc, agentNodeID, agentID);
    }

    public final JmxAgentBeanManagementClient getAgentBeanManagementClient(String agentNodeID, String agentID, String agentBeanName) throws MalformedObjectNameException {
        return new JmxAgentBeanManagementClient(this.mbsc, agentNodeID, agentID, agentBeanName);
    }

    public final JmxAgentNodeDirectoryManagementClient getDirectoryManagementClient(String agentNodeID) throws MalformedObjectNameException, InstanceNotFoundException, IOException {
        String directoryBeanName = this.getAgentNodeManagementClient(agentNodeID).getDirectoryName();
        return new JmxAgentNodeDirectoryManagementClient(this.mbsc, agentNodeID, directoryBeanName);
    }

    public final JmxAgentMemoryManagementClient getAgentMemoryManagementClient(String agentNodeID, String agentID) throws MalformedObjectNameException {
        return new JmxAgentMemoryManagementClient(this.mbsc, agentNodeID, agentID);
    }

    public final JmxAgentExecutionCycleManagementClient getAgentExecutionCycleManagementClient(String agentNodeID, String agentID) throws MalformedObjectNameException {
        return new JmxAgentExecutionCycleManagementClient(this.mbsc, agentNodeID, agentID);
    }

    public final Set<JmxAgentCommunicationManagementClient> getAgentCommunicationManagementClients(String agentNodeID, String agentID) throws MalformedObjectNameException, IOException {
        HashSet<JmxAgentCommunicationManagementClient> clients = new HashSet<JmxAgentCommunicationManagementClient>();
        Set<ObjectInstance> beans = this.mbsc.queryMBeans(new JmxManager().getMgmtNameOfAgentBean(agentNodeID, agentID, "*"), null);
        for (ObjectInstance bean : beans) {
            try {
                if (!this.mbsc.isInstanceOf(bean.getObjectName(), CommunicationBeanMBean.class.getName())) continue;
                clients.add(new JmxAgentCommunicationManagementClient(this.mbsc, bean.getObjectName()));
            }
            catch (InstanceNotFoundException infe) {
                infe.printStackTrace();
            }
        }
        return clients;
    }
}

