/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.util;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public final class IdFactory {
    public static final int DEFAULT_LENGTH = 12;
    private static final int NANO_SLEEP = 5;
    private static Set<String> allocatedSessions = new HashSet<String>();

    private IdFactory() {
    }

    public static String createPlatformId(int hashcode) {
        return IdFactory.createId(IdPrefix.Platform, hashcode);
    }

    public static String createAgentNodeId(int hashcode) {
        return IdFactory.createId(IdPrefix.Node, hashcode);
    }

    public static String createAgentId(int hashcode) {
        return IdFactory.createId(IdPrefix.Agent, hashcode);
    }

    public static String createSessionId(int hashcode) {
        return IdFactory.createId(IdPrefix.Session, hashcode);
    }

    public static String createId(IdPrefix prefix, int hashcode) {
        return prefix.toString() + Long.toHexString(System.nanoTime() + (long)hashcode);
    }

    public static String generate(int length) {
        StringBuilder buffer = new StringBuilder("");
        String output = null;
        Random random = new Random();
        int oneRandomInt = 0;
        for (int i = 0; i < length; ++i) {
            oneRandomInt = random.nextInt(16);
            if (oneRandomInt == 10) {
                buffer.append("a");
            } else if (oneRandomInt == 11) {
                buffer.append("b");
            } else if (oneRandomInt == 12) {
                buffer.append("c");
            } else if (oneRandomInt == 13) {
                buffer.append("d");
            } else if (oneRandomInt == 14) {
                buffer.append("e");
            } else if (oneRandomInt == 15) {
                buffer.append("f");
            } else {
                buffer.append(oneRandomInt);
            }
            try {
                Thread.sleep(0L, 5);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        output = buffer.toString();
        while (allocatedSessions.contains(output)) {
            output = IdFactory.generate(length);
        }
        allocatedSessions.add(output);
        return output;
    }

    public static String generate() {
        return IdFactory.generate(12);
    }

    public static void devaluate(String session) {
        allocatedSessions.remove(session);
    }

    public static enum IdPrefix {
        Agent("a-"),
        Platform("p-"),
        Node("n-"),
        Session("s-");

        private final String value;

        private IdPrefix(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

