/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.util.jar;

import de.dailab.jiactng.agentcore.util.jar.JAR;
import de.dailab.jiactng.agentcore.util.jar.JARClassPath;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;

public class JARClassLoader
extends URLClassLoader {
    private static final JARClassLoader CLASSLOADER = new JARClassLoader();
    private final JARClassPath jarCP = new JARClassPath();
    private HashMap<String, Class<?>> loadedClasses = new HashMap();

    public static JARClassLoader getJVMClassLoader() {
        return CLASSLOADER;
    }

    public JARClassLoader() {
        super(new URL[0], JARClassLoader.class.getClassLoader());
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public synchronized URL addURL(String url) throws MalformedURLException {
        URL u = new URL(url);
        this.addURL(u);
        return u;
    }

    public synchronized void addJAR(JAR jar) {
        this.jarCP.addJAR(jar);
    }

    public synchronized JAR addJAR(String resource) throws IOException, FileNotFoundException {
        return this.jarCP.addJAR(resource);
    }

    @Override
    public synchronized URL findResource(String name) {
        URL result = this.jarCP.getURL(name);
        return result == null ? super.findResource(name) : result;
    }

    @Override
    public synchronized Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> result = Collections.list(super.findResources(name));
        URL localURL = this.jarCP.getURL(name);
        if (localURL != null) {
            result.add(localURL);
        }
        return Collections.enumeration(result);
    }

    public JAR[] getJARs() {
        return this.jarCP.getJARs();
    }

    public synchronized boolean addClass(byte[] code) {
        this.resolveClass(this.defineClass(null, code, 0, code.length));
        return true;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JARClassLoader: ");
        JAR[] jars = this.getJARs();
        sb.append("\njars [").append(jars.length).append("]\n");
        for (JAR jar : jars) {
            sb.append('\t').append(jar).append('\n');
        }
        URL[] urls = this.getURLs();
        sb.append("\nurls [").append(urls.length).append("]\n");
        for (URL url : urls) {
            sb.append('\t').append(url).append('\n');
        }
        return sb.toString();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> c = this.loadedClasses.get(name);
        if (c != null) {
            return c;
        }
        try {
            c = this.findClass(name);
            this.loadedClasses.put(name, c);
            return c;
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name);
        }
    }

    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        String fileName = new StringBuffer().append(name.replace('.', '/')).append(".class").toString();
        JAR jar = this.jarCP.getContainer(fileName);
        if (jar != null) {
            try {
                InputStream is = jar.getInputStream(fileName);
                byte[] classCode = this.getBytes(is);
                is.close();
                URL url = this.jarCP.getURL(jar, fileName);
                CodeSource cs = url == null ? null : new CodeSource(url, (Certificate[])null);
                return this.defineClass(name, classCode, 0, classCode.length, cs);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    private byte[] getBytes(InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, n);
        }
        return baos.toByteArray();
    }
}

