/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.util.jar;

import de.dailab.jiactng.agentcore.util.jar.JAR;
import de.dailab.jiactng.agentcore.util.jar.JARClassLoader;
import de.dailab.jiactng.agentcore.util.jar.JARFile;
import de.dailab.jiactng.agentcore.util.jar.JARMemory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class JARClassPath {
    private final URLStreamHandler streamHandler = new URLStreamHandler(){

        @Override
        protected URLConnection openConnection(URL u) {
            return new JARConnection(u);
        }
    };
    private final Set<JAR> jars = new HashSet<JAR>();
    private final Map<String, URL> urlCache = new HashMap<String, URL>();

    JARClassPath() {
    }

    private static File fileFromName(String resource) {
        File file = new File(resource);
        if (file.isFile()) {
            return file;
        }
        URL url = JARClassLoader.getJVMClassLoader().getResource(resource);
        if (url == null || !"file".equals(url.getProtocol())) {
            return null;
        }
        file = new File(url.getFile());
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    synchronized void addJAR(JAR jar) {
        this.jars.add(jar);
    }

    synchronized JAR addJAR(String resource) throws IOException {
        JAR jar;
        File file = JARClassPath.fileFromName(resource);
        if (file != null) {
            jar = new JARFile(file);
        } else {
            try {
                URL url = new URL(resource);
                jar = !url.getProtocol().equals("file") ? new JARMemory(resource, url.openStream()) : new JARMemory(new File(url.getFile()));
            }
            catch (MalformedURLException ioe) {
                jar = new JARMemory(new File(resource));
            }
        }
        this.addJAR(jar);
        return jar;
    }

    synchronized JAR[] getJARs() {
        return this.jars.toArray(new JAR[this.jars.size()]);
    }

    synchronized JAR getContainer(String entry) {
        for (JAR jar : this.jars) {
            if (!jar.constainsResource(entry)) continue;
            return jar;
        }
        return null;
    }

    synchronized URL getURL(String entry) {
        return this.getURL(this.getContainer(entry), entry);
    }

    synchronized URL getURL(JAR container, String entry) {
        URL result = this.urlCache.get(entry);
        if (result != null) {
            return result;
        }
        if (container == null || !container.constainsResource(entry)) {
            return null;
        }
        try {
            String location = container.getJarName() + "!" + entry;
            result = new URL("jarcl", null, -1, location, this.streamHandler);
            this.urlCache.put(entry, result);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    synchronized JAR getJAR(String name) {
        for (JAR jar : this.jars) {
            if (!jar.getJarName().equals(name)) continue;
            return jar;
        }
        return null;
    }

    private final class JARConnection
    extends URLConnection {
        private boolean connected;
        private int contentLength;
        private long contentTime;
        private String contentType;
        private InputStream sourceStream;

        JARConnection(URL url) {
            super(url);
            this.connected = false;
        }

        @Override
        public void connect() throws IOException {
            if (!this.connected) {
                String resource = this.url.getFile();
                if (resource == null || resource.length() <= 0) {
                    throw new IOException("Unable to find resource: " + this.url.toString());
                }
                int index = resource.indexOf(33);
                if (index <= 0 || index >= resource.length() - 1) {
                    throw new IOException("The URL is no valid resource location: " + this.url.toString());
                }
                String containerName = resource.substring(0, index);
                String fileName = resource.substring(index + 1);
                JAR container = JARClassPath.this.getJAR(containerName);
                if (container == null) {
                    throw new IOException("Unable to find container: " + containerName);
                }
                this.sourceStream = container.getInputStream(fileName);
                if (this.sourceStream == null) {
                    throw new IOException("Unable to find content for: " + fileName);
                }
                this.contentLength = this.sourceStream.available();
                this.contentTime = System.currentTimeMillis();
                this.contentType = JARConnection.guessContentTypeFromName(resource);
                this.connected = true;
            }
        }

        @Override
        public int getContentLength() {
            if (!this.connected) {
                try {
                    this.connect();
                }
                catch (IOException e) {
                    return -1;
                }
            }
            return this.contentLength;
        }

        @Override
        public String getContentType() {
            if (!this.connected) {
                try {
                    this.connect();
                }
                catch (IOException e) {
                    return null;
                }
            }
            return this.contentType;
        }

        @Override
        public long getDate() {
            if (!this.connected) {
                try {
                    this.connect();
                }
                catch (IOException e) {
                    return 0L;
                }
            }
            return this.contentTime;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.sourceStream;
        }

        @Override
        public long getLastModified() {
            if (!this.connected) {
                try {
                    this.connect();
                }
                catch (IOException e) {
                    return 0L;
                }
            }
            return this.contentTime;
        }
    }
}

