/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.util.jar;

import de.dailab.jiactng.agentcore.util.jar.JAR;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JARFile
extends JarFile
implements JAR {
    private String name;

    public JARFile(File file) throws IOException {
        super(file);
        this.name = file.getPath();
    }

    @Override
    public InputStream getInputStream(String entryName) {
        JarEntry entry = this.getJarEntry(entryName);
        try {
            if (entry != null) {
                return this.getInputStream(entry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getJarName() {
        return this.name;
    }

    @Override
    public boolean constainsResource(String resource) {
        return this.getJarEntry(resource) != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JAR)) {
            return false;
        }
        return this.name.equals(((JAR)o).getJarName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "JARFile :: " + this.getJarName();
    }
}

