/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.util.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class JARFileReader
extends ClassLoader {
    private JarFile jarFile;
    private String jarFileName;

    public JARFileReader(String jarFileName) throws IOException {
        this.jarFileName = jarFileName;
        this.jarFile = new JarFile(jarFileName);
    }

    public Vector<JarEntry> getAllEntries() {
        Vector<JarEntry> jarFileEntries = new Vector<JarEntry>();
        Enumeration<JarEntry> enumList = this.jarFile.entries();
        while (enumList.hasMoreElements()) {
            JarEntry entry = enumList.nextElement();
            jarFileEntries.add(entry);
        }
        return jarFileEntries;
    }

    public Enumeration<JarEntry> getEntries() {
        return this.jarFile.entries();
    }

    public void extractAll() {
        try {
            JarEntry entry;
            byte[] buf = new byte[4096];
            JarInputStream in = new JarInputStream(new FileInputStream(this.jarFileName));
            String fileSeparator = System.getProperty("file.separator");
            StringTokenizer st = new StringTokenizer(this.jarFileName, fileSeparator);
            File tempFile = null;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.endsWith(".jar")) continue;
                String dirName = token.substring(0, token.length() - 4);
                tempFile = new File(dirName);
                tempFile.mkdir();
                break;
            }
            String pathToTmpFile = tempFile.getAbsolutePath();
            FileOutputStream out = null;
            while ((entry = (JarEntry)in.getNextEntry()) != null) {
                int len;
                if (entry.isDirectory()) {
                    String dirName = entry.getName();
                    File jarDir = new File(new StringBuffer().append(pathToTmpFile).append(fileSeparator).append(dirName).toString());
                    jarDir.mkdir();
                }
                if (entry.isDirectory()) continue;
                out = new FileOutputStream(new StringBuffer().append(pathToTmpFile).append(fileSeparator).append(entry.getName()).toString());
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
                in.closeEntry();
            }
            in.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
    }
}

