/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.util.jar;

import de.dailab.jiactng.agentcore.util.jar.JAR;
import de.dailab.jiactng.agentcore.util.jar.JARClassLoader;
import de.dailab.jiactng.agentcore.util.jar.JARFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class JARMemory
implements JAR,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private byte[] jar = new byte[0];

    public JARMemory(JARFile file) throws IOException, FileNotFoundException {
        this(new File(file.getJarName()));
    }

    public JARMemory(String resource) throws IOException, FileNotFoundException {
        this(resource, JARClassLoader.getJVMClassLoader().getResourceAsStream(resource));
    }

    public JARMemory(File file) throws IOException, FileNotFoundException {
        this(file.toString(), new FileInputStream(file));
    }

    public JARMemory(String name, InputStream in) throws IOException {
        this.name = name;
        this.readJAR(in);
    }

    private void readJAR(InputStream is) throws IOException {
        int numBytes;
        ByteArrayOutputStream temp = new ByteArrayOutputStream(4096);
        byte[] readBuffer = new byte[4096];
        while ((numBytes = is.read(readBuffer)) != -1) {
            temp.write(readBuffer, 0, numBytes);
        }
        this.jar = temp.toByteArray();
    }

    @Override
    public InputStream getInputStream(String entryName) {
        try {
            JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.jar));
            while (jis.available() != 0) {
                JarEntry je = jis.getNextJarEntry();
                if (je == null || !je.getName().equals(entryName)) continue;
                return jis;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return null;
    }

    @Override
    public String getJarName() {
        return this.name;
    }

    @Override
    public boolean constainsResource(String resource) {
        try {
            JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.jar));
            while (jis.available() != 0) {
                JarEntry je = jis.getNextJarEntry();
                if (je == null || !je.getName().equals(resource)) continue;
                return true;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JAR)) {
            return false;
        }
        return this.name.equals(((JAR)o).getJarName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public byte[] getByteArray() {
        byte[] result = new byte[this.jar.length];
        System.arraycopy(this.jar, 0, result, 0, result.length);
        return result;
    }

    public String toString() {
        return "JARMemory :: " + this.getJarName();
    }
}

