/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlphaStore {
    List<AlphaNode> nodes = new ArrayList<AlphaNode>();
    Map<ATermAppl, List<AlphaNode>> sharedIndex = new HashMap<ATermAppl, List<AlphaNode>>();

    public void addNode(AlphaNode node) {
        if (!this.nodes.contains(node)) {
            this.nodes.add(node);
            for (ATermAppl var : node.vars) {
                List<Object> l;
                if (!this.sharedIndex.containsKey(var)) {
                    l = new ArrayList<AlphaNode>();
                    l.add(node);
                    this.sharedIndex.put(var, l);
                    continue;
                }
                l = this.sharedIndex.get(var);
                l.add(node);
                this.sharedIndex.put(var, l);
            }
        }
    }

    public void sort() {
        List<AlphaNode> sortedNonBuiltins = new ArrayList();
        for (AlphaNode node : this.nodes) {
            for (ATermAppl var : node.vars) {
                List<AlphaNode> nodesThatShare = this.sharedIndex.get(var);
                if (nodesThatShare.size() <= 0) continue;
                sortedNonBuiltins.addAll(nodesThatShare);
                sortedNonBuiltins.add(node);
            }
        }
        sortedNonBuiltins = Utils.removeDups(sortedNonBuiltins);
        this.nodes.addAll(0, sortedNonBuiltins);
        this.nodes = Utils.removeDups(this.nodes);
    }

    public String toString() {
        String tmp = "";
        for (AlphaNode node : this.nodes) {
            tmp = tmp + ((Object)node).toString() + "\n";
        }
        return tmp;
    }
}

