/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import sun.security.action.GetPropertyAction;

public class JenaRuntime {
    public static final String featureNoSecurity = "http://jena.hpl.hp.com/2004/07/feature/noSecurity";
    public static final String featureNoCharset = "http://jena.hpl.hp.com/2004/07/feature/noCharset";
    static Map features = new HashMap();
    static final String lineSeparator;

    public static void setFeature(String featureName) {
        features.put(featureName, "true");
    }

    public static boolean runUnder(String featureName) {
        return features.containsKey(featureName);
    }

    public static boolean runNotUnder(String featureName) {
        return !features.containsKey(featureName);
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getSystemProperty(String propName) {
        return JenaRuntime.getSystemProperty(propName, null);
    }

    public static String getSystemProperty(String propName, String defaultValue) {
        try {
            return System.getProperty(propName, defaultValue);
        }
        catch (SecurityException ex) {
            if (JenaRuntime.runUnder(featureNoSecurity)) {
                return defaultValue;
            }
            try {
                String x = AccessController.doPrivileged(new GetPropertyAction(propName));
                return x;
            }
            catch (Exception ex2) {
                return defaultValue;
            }
        }
    }

    static {
        if (JenaRuntime.getSystemProperty(featureNoSecurity) != null) {
            JenaRuntime.setFeature(featureNoSecurity);
        }
        if (JenaRuntime.getSystemProperty(featureNoCharset) != null) {
            JenaRuntime.setFeature(featureNoCharset);
        }
        lineSeparator = JenaRuntime.getSystemProperty("line.separator", "\n");
    }
}

