/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.datatypes;

import mx.com.hp.hpl.jena.datatypes.DatatypeFormatException;
import mx.com.hp.hpl.jena.datatypes.RDFDatatype;
import mx.com.hp.hpl.jena.graph.impl.LiteralLabel;

public class BaseDatatype
implements RDFDatatype {
    protected String uri;

    public BaseDatatype(String uri) {
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public String unparse(Object value) {
        if (value instanceof TypedValue) {
            return ((TypedValue)value).lexicalValue;
        }
        return value.toString();
    }

    public Object parse(String lexicalForm) throws DatatypeFormatException {
        return new TypedValue(lexicalForm, this.getURI());
    }

    public boolean isValid(String lexicalForm) {
        try {
            this.parse(lexicalForm);
            return true;
        }
        catch (DatatypeFormatException e) {
            return false;
        }
    }

    public boolean isValidLiteral(LiteralLabel lit) {
        return this.equals(lit.getDatatype());
    }

    public boolean isValidValue(Object valueForm) {
        return this.isValid(this.unparse(valueForm));
    }

    public boolean isEqual(LiteralLabel value1, LiteralLabel value2) {
        return value1.getDatatype() == value2.getDatatype() && value1.getValue().equals(value2.getValue());
    }

    public boolean langTagCompatible(LiteralLabel value1, LiteralLabel value2) {
        if (value1.language() == null) {
            return value2.language() == null || value2.language().equals("");
        }
        return value1.language().equalsIgnoreCase(value2.language());
    }

    public Class getJavaClass() {
        return null;
    }

    public Object cannonicalise(Object value) {
        return value;
    }

    public Object extendedTypeDefinition() {
        return null;
    }

    public RDFDatatype getNarrowedDatatype(Object value) {
        return this;
    }

    public String toString() {
        return "Datatype[" + this.uri + (this.getJavaClass() == null ? "" : " -> " + this.getJavaClass()) + "]";
    }

    public static class TypedValue {
        public final String lexicalValue;
        public final String datatypeURI;

        public TypedValue(String lexicalValue, String datatypeURI) {
            this.lexicalValue = lexicalValue;
            this.datatypeURI = datatypeURI;
        }

        public boolean equals(Object other) {
            if (other instanceof TypedValue) {
                return this.lexicalValue.equals(((TypedValue)other).lexicalValue) && this.datatypeURI.equals(((TypedValue)other).datatypeURI);
            }
            return false;
        }

        public int hashCode() {
            return this.lexicalValue.hashCode() ^ this.datatypeURI.hashCode();
        }
    }
}

