/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.datatypes.xsd;

public class AbstractDateTime {
    protected int[] data;
    protected double fractionalSeconds;
    protected static final int CY = 0;
    protected static final int M = 1;
    protected static final int D = 2;
    protected static final int h = 3;
    protected static final int m = 4;
    protected static final int s = 5;
    protected static final int ms = 6;
    protected static final int utc = 7;
    protected static final int hh = 0;
    protected static final int mm = 1;
    protected static final int TOTAL_SIZE = 8;
    public static final short LESS_THAN = -1;
    public static final short EQUAL = 0;
    public static final short GREATER_THAN = 1;
    public static final short INDETERMINATE = 2;

    public AbstractDateTime(Object value) {
        this.data = (int[])value;
        if (this.data[7] == 0) {
            this.data[7] = 90;
        }
        this.extractFractionalSeconds();
    }

    public int compare(AbstractDateTime other) {
        return this.compareDates(this.data, other.data, true);
    }

    protected void extractFractionalSeconds() {
        if (this.data[6] != 0) {
            int fs = this.data[6];
            double log10 = Math.log(fs) / 2.302585093;
            int exp = 1 + (int)(log10 / 10.0);
            this.fractionalSeconds = (double)fs / Math.pow(10.0, exp);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractDateTime) {
            AbstractDateTime adt = (AbstractDateTime)obj;
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == adt.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.data.length; ++i) {
            hash = hash << 1 ^ this.data[i];
        }
        return hash;
    }

    protected short compareDates(int[] date1, int[] date2, boolean strict) {
        if (date1[7] == date2[7]) {
            return this.compareOrder(date1, date2);
        }
        int[] tempDate = new int[8];
        int[] timeZone = new int[2];
        if (date1[7] == 90) {
            this.cloneDate(date2, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 43;
            AbstractDateTime.normalize(tempDate, timeZone);
            short c1 = this.compareOrder(date1, tempDate);
            if (c1 == -1) {
                return c1;
            }
            this.cloneDate(date2, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 45;
            AbstractDateTime.normalize(tempDate, timeZone);
            short c2 = this.compareOrder(date1, tempDate);
            if (c2 == 1) {
                return c2;
            }
            return 2;
        }
        if (date2[7] == 90) {
            this.cloneDate(date1, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 45;
            AbstractDateTime.normalize(tempDate, timeZone);
            short c1 = this.compareOrder(tempDate, date2);
            if (c1 == -1) {
                return c1;
            }
            this.cloneDate(date1, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 43;
            AbstractDateTime.normalize(tempDate, timeZone);
            short c2 = this.compareOrder(tempDate, date2);
            if (c2 == 1) {
                return c2;
            }
            return 2;
        }
        return 2;
    }

    protected short compareOrder(int[] date1, int[] date2) {
        for (int i = 0; i < 8; ++i) {
            if (date1[i] < date2[i]) {
                return -1;
            }
            if (date1[i] <= date2[i]) continue;
            return 1;
        }
        return 0;
    }

    public static void normalize(int[] date, int[] timeZone) {
        int negate = 1;
        if (date[7] == 43) {
            negate = -1;
        }
        int temp = date[4] + negate * timeZone[1];
        int carry = AbstractDateTime.fQuotient(temp, 60);
        date[4] = AbstractDateTime.mod(temp, 60, carry);
        temp = date[3] + negate * timeZone[0] + carry;
        carry = AbstractDateTime.fQuotient(temp, 24);
        date[3] = AbstractDateTime.mod(temp, 24, carry);
        date[2] = date[2] + carry;
        while (true) {
            temp = AbstractDateTime.maxDayInMonthFor(date[0], date[1]);
            if (date[2] < 1) {
                date[2] = date[2] + AbstractDateTime.maxDayInMonthFor(date[0], date[1] - 1);
                carry = -1;
            } else {
                if (date[2] <= temp) break;
                date[2] = date[2] - temp;
                carry = 1;
            }
            temp = date[1] + carry;
            date[1] = AbstractDateTime.modulo(temp, 1, 13);
            date[0] = date[0] + AbstractDateTime.fQuotient(temp, 1, 13);
        }
        date[7] = 90;
    }

    protected void resetDateObj(int[] data) {
        for (int i = 0; i < 8; ++i) {
            data[i] = 0;
        }
    }

    protected static int maxDayInMonthFor(int year, int month) {
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            if (AbstractDateTime.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    protected static int mod(int a, int b, int quotient) {
        return a - quotient * b;
    }

    protected static int fQuotient(int a, int b) {
        return (int)Math.floor((float)a / (float)b);
    }

    protected static int modulo(int temp, int low, int high) {
        int a = temp - low;
        int b = high - low;
        return AbstractDateTime.mod(a, b, AbstractDateTime.fQuotient(a, b)) + low;
    }

    protected static int fQuotient(int temp, int low, int high) {
        return AbstractDateTime.fQuotient(temp - low, high - low);
    }

    private void cloneDate(int[] finalValue, int[] tempDate) {
        System.arraycopy(finalValue, 0, tempDate, 0, 8);
    }
}

