/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.datatypes.xsd.impl;

import java.io.IOException;
import java.io.StringReader;
import mx.com.hp.hpl.jena.datatypes.BaseDatatype;
import mx.com.hp.hpl.jena.datatypes.DatatypeFormatException;
import mx.com.hp.hpl.jena.datatypes.RDFDatatype;
import mx.com.hp.hpl.jena.rdf.arp.ALiteral;
import mx.com.hp.hpl.jena.rdf.arp.ARP;
import mx.com.hp.hpl.jena.rdf.arp.AResource;
import mx.com.hp.hpl.jena.rdf.arp.StatementHandler;
import mx.com.hp.hpl.jena.shared.BrokenException;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLiteralType
extends BaseDatatype
implements RDFDatatype {
    public static final RDFDatatype theXMLLiteralType = new XMLLiteralType(RDF.getURI() + "XMLLiteral");

    private XMLLiteralType(String uri) {
        super(uri);
    }

    public String unparse(Object value) {
        return value.toString();
    }

    public Object parse(String lexicalForm) throws DatatypeFormatException {
        if (!this.isValid(lexicalForm)) {
            throw new DatatypeFormatException("Bad rdf:XMLLiteral");
        }
        return lexicalForm;
    }

    public boolean isValid(final String lexicalForm) {
        final boolean[] status = new boolean[]{false, false, false};
        ARP arp = new ARP();
        arp.getHandlers().setErrorHandler(new ErrorHandler(){

            public void fatalError(SAXParseException e) {
                status[0] = true;
            }

            public void error(SAXParseException e) {
                status[0] = true;
            }

            public void warning(SAXParseException e) {
                status[0] = true;
            }
        });
        arp.getHandlers().setStatementHandler(new StatementHandler(){

            public void statement(AResource a, AResource b, ALiteral l) {
                if (status[1] || !l.isWellFormedXML()) {
                    status[0] = true;
                }
                status[1] = true;
                status[2] = ((Object)l).toString().equals(lexicalForm);
            }

            public void statement(AResource a, AResource b, AResource l) {
                status[0] = true;
            }
        });
        try {
            arp.load(new StringReader("<rdf:RDF  xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n<rdf:Description><rdf:value rdf:parseType='Literal'>" + lexicalForm + "</rdf:value>\n" + "</rdf:Description></rdf:RDF>"));
        }
        catch (IOException ioe) {
            throw new BrokenException(ioe);
        }
        catch (SAXException s) {
            return false;
        }
        return !status[0] && status[1] && status[2];
    }
}

