/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.db.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.db.GraphRDB;
import mx.com.hp.hpl.jena.graph.BulkUpdateHandler;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.GraphEventManager;
import mx.com.hp.hpl.jena.graph.GraphEvents;
import mx.com.hp.hpl.jena.graph.GraphUtil;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import mx.com.hp.hpl.jena.util.IteratorCollection;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class DBBulkUpdateHandler
implements BulkUpdateHandler {
    private GraphRDB graph;
    private GraphEventManager manager;
    protected static int CHUNK_SIZE = 50;

    public DBBulkUpdateHandler(GraphRDB graph) {
        this.graph = graph;
        this.manager = graph.getEventManager();
    }

    public void add(Triple[] triples) {
        this.add(Arrays.asList(triples), false);
        this.manager.notifyAddArray(this.graph, triples);
    }

    public void add(List triples) {
        this.add(triples, true);
    }

    protected void add(List triples, boolean notify) {
        this.graph.add(triples);
        if (notify) {
            this.manager.notifyAddList(this.graph, triples);
        }
    }

    public void add(Iterator it) {
        if (this.manager.listening()) {
            List L = IteratorCollection.iteratorToList(it);
            this.add(L, false);
            this.manager.notifyAddIterator((Graph)this.graph, L);
        } else {
            this.addIterator(it);
        }
    }

    protected void addIterator(Iterator it) {
        ArrayList list = new ArrayList(CHUNK_SIZE);
        while (it.hasNext()) {
            while (it.hasNext() && list.size() < CHUNK_SIZE) {
                list.add(it.next());
            }
            this.graph.add(list);
            list.clear();
        }
    }

    public void add(Graph g) {
        this.add(g, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Graph g, boolean withReifications) {
        ExtendedIterator triplesToAdd = GraphUtil.findAll(g);
        try {
            this.addIterator(triplesToAdd);
        }
        finally {
            triplesToAdd.close();
        }
        if (withReifications) {
            SimpleBulkUpdateHandler.addReifications(this.graph, g);
        }
        this.manager.notifyAddGraph(this.graph, g);
    }

    public void delete(Triple[] triples) {
        this.delete(Arrays.asList(triples), false);
        this.manager.notifyDeleteArray(this.graph, triples);
    }

    public void delete(List triples) {
        this.delete(triples, true);
    }

    protected void delete(List triples, boolean notify) {
        this.graph.delete(triples);
        if (notify) {
            this.manager.notifyDeleteList(this.graph, triples);
        }
    }

    public void delete(Iterator it) {
        if (this.manager.listening()) {
            List L = IteratorCollection.iteratorToList(it);
            this.delete(L, false);
            this.manager.notifyDeleteIterator((Graph)this.graph, L);
        } else {
            this.deleteIterator(it);
        }
    }

    protected void deleteIterator(Iterator it) {
        ArrayList list = new ArrayList(CHUNK_SIZE);
        while (it.hasNext()) {
            while (it.hasNext() && list.size() < CHUNK_SIZE) {
                list.add(it.next());
            }
            this.graph.delete(list);
            list.clear();
        }
    }

    public void delete(Graph g) {
        this.delete(g, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Graph g, boolean withReifications) {
        ExtendedIterator triplesToDelete = GraphUtil.findAll(g);
        try {
            this.deleteIterator(triplesToDelete);
        }
        finally {
            triplesToDelete.close();
        }
        if (withReifications) {
            SimpleBulkUpdateHandler.deleteReifications(this.graph, g);
        }
        this.manager.notifyDeleteGraph(this.graph, g);
    }

    public void removeAll() {
        SimpleBulkUpdateHandler.removeAll(this.graph);
        this.manager.notifyEvent(this.graph, GraphEvents.removeAll);
    }

    public void remove(Node s, Node p, Node o) {
        SimpleBulkUpdateHandler.removeAll(this.graph, s, p, o);
        this.manager.notifyEvent(this.graph, GraphEvents.remove(s, p, o));
    }
}

