/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.db.impl;

import java.util.ArrayList;
import java.util.List;
import mx.com.hp.hpl.jena.db.RDFRDBException;
import mx.com.hp.hpl.jena.db.impl.Free;
import mx.com.hp.hpl.jena.db.impl.SpecializedGraph;
import mx.com.hp.hpl.jena.db.impl.SpecializedGraphReifier_RDB;
import mx.com.hp.hpl.jena.db.impl.VarDesc;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Node_Variable;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.query.Bound;
import mx.com.hp.hpl.jena.graph.query.Element;
import mx.com.hp.hpl.jena.graph.query.Fixed;
import mx.com.hp.hpl.jena.graph.query.Mapping;
import mx.com.hp.hpl.jena.graph.query.Query;

public class DBPattern {
    Triple pattern;
    Element S;
    Element P;
    Element O;
    int Scost;
    int Pcost;
    int Ocost;
    boolean isStaged;
    boolean isConnected;
    boolean isSingleSource;
    boolean isStmt;
    boolean isReif;
    List source;
    char subsumed;
    static final int costMax = 100;
    static final int costMin = 1;
    int costCur;
    private boolean costInit = true;
    private int freeVarCnt = 0;
    private int fixedCost = 0;
    private int boundCost = 0;
    private int unboundCost = 4;

    public DBPattern(Triple pat, Mapping varMap) {
        this.pattern = pat;
        this.source = new ArrayList();
        this.isStaged = false;
        this.isConnected = false;
        this.isSingleSource = false;
        this.isReif = false;
        this.isStmt = false;
        this.S = this.nodeToElement(this.pattern.getSubject(), varMap);
        this.P = this.nodeToElement(this.pattern.getPredicate(), varMap);
        this.O = this.nodeToElement(this.pattern.getObject(), varMap);
        this.Scost = this.elementCost(this.S);
        this.Pcost = this.elementCost(this.P);
        this.Ocost = this.elementCost(this.O);
    }

    private Element nodeToElement(Node X, Mapping map) {
        if (X.equals(Query.ANY)) {
            return Element.ANY;
        }
        if (X.isVariable()) {
            if (map.hasBound(X)) {
                return new Bound(map.indexOf(X));
            }
            ++this.freeVarCnt;
            return new Free(X);
        }
        return new Fixed(X);
    }

    public void sourceAdd(SpecializedGraph sg, char sub) {
        if (this.source.isEmpty()) {
            this.subsumed = sub;
            this.isSingleSource = true;
            if (sg instanceof SpecializedGraphReifier_RDB) {
                this.isReif = true;
            } else {
                this.isStmt = true;
            }
        } else {
            if (this.subsumed != sub) {
                throw new RDFRDBException("Specialized graphs incorrectly subsume pattern");
            }
            this.isSingleSource = false;
            if (sg instanceof SpecializedGraphReifier_RDB) {
                this.isStmt = false;
            } else {
                this.isReif = false;
            }
        }
        this.source.add(sg);
    }

    public boolean hasSource() {
        return !this.source.isEmpty();
    }

    public boolean isSingleSource() {
        return this.isSingleSource;
    }

    public SpecializedGraph singleSource() {
        return (SpecializedGraph)this.source.get(0);
    }

    protected void addFreeVars(List varList) {
        if (this.freeVarCnt > 0) {
            if (this.S instanceof Free) {
                this.addVar(varList, (Free)this.S);
            }
            if (this.P instanceof Free) {
                this.addVar(varList, (Free)this.P);
            }
            if (this.O instanceof Free) {
                this.addVar(varList, (Free)this.O);
            }
        }
    }

    private int findVar(List varList, Node_Variable var) {
        for (int i = 0; i < varList.size(); ++i) {
            Node_Variable v = ((VarDesc)varList.get((int)i)).var;
            if (!var.equals(v)) continue;
            return i;
        }
        return -1;
    }

    private void addVar(List varList, Free var) {
        int i = this.findVar(varList, var.var());
        if (i < 0) {
            i = varList.size();
            VarDesc vx = var.isArg() ? new VarDesc(var.var(), var.getMapping(), i) : new VarDesc(var.var(), i);
            varList.add(vx);
        }
        var.setListing(i);
    }

    public boolean joinsWith(DBPattern jsrc, List varList, boolean onlyStmt, boolean onlyReif, boolean implJoin) {
        if (jsrc.isSingleSource() && this.source.contains(jsrc.source.get(0)) && (!(this.P instanceof Free) || onlyStmt && this.isStmt)) {
            if (this.S instanceof Free && this.findVar(varList, ((Free)this.S).var()) >= 0) {
                return true;
            }
            if (this.O instanceof Free && this.findVar(varList, ((Free)this.O).var()) >= 0) {
                return true;
            }
            if (onlyStmt && this.isStmt && this.P instanceof Free && this.findVar(varList, ((Free)this.P).var()) >= 0) {
                return true;
            }
            if (implJoin && this.S instanceof Fixed && jsrc.S instanceof Fixed && this.S.match(null, jsrc.S.asNodeMatch(null))) {
                return true;
            }
        }
        return false;
    }

    public int cost(Mapping varMap) {
        if (this.costInit) {
            this.costInit = false;
            this.costCur = this.costCalc();
        } else if (this.freeVarCnt > 0 && this.anyBound(varMap)) {
            this.costCur = this.costCalc();
        }
        return this.costCur;
    }

    protected boolean isArgCheck(Free v, Mapping map) {
        int ix = map.lookUp(v.var());
        if (ix >= 0) {
            v.setIsArg(ix);
            this.isConnected = true;
            --this.freeVarCnt;
            return true;
        }
        return false;
    }

    protected boolean anyBound(Mapping map) {
        boolean res = false;
        if (this.S instanceof Free && this.isArgCheck((Free)this.S, map)) {
            this.Scost = this.elementCost(this.S);
            res = true;
        }
        if (this.P instanceof Free && this.isArgCheck((Free)this.P, map)) {
            this.Pcost = this.elementCost(this.P);
            res = true;
        }
        if (this.O instanceof Free && this.isArgCheck((Free)this.O, map)) {
            this.Ocost = this.elementCost(this.O);
            res = true;
        }
        return res;
    }

    private int elementCost(Element x) {
        if (x instanceof Fixed) {
            return this.fixedCost;
        }
        if (x instanceof Bound) {
            return this.boundCost;
        }
        if (x instanceof Free && ((Free)x).isArg()) {
            return this.boundCost;
        }
        return this.unboundCost;
    }

    private int costCalc() {
        return this.Scost + this.Pcost + this.Ocost;
    }
}

