/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.db.impl;

import mx.com.hp.hpl.jena.db.impl.DBProp;
import mx.com.hp.hpl.jena.db.impl.DBPropLSet;
import mx.com.hp.hpl.jena.db.impl.DBPropPrefix;
import mx.com.hp.hpl.jena.db.impl.SpecializedGraph;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Node_URI;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.Map1;
import mx.com.hp.hpl.jena.vocabulary.DB;

public class DBPropGraph
extends DBProp {
    public static Node_URI graphName = (Node_URI)DB.graphName.asNode();
    public static Node_URI graphType = (Node_URI)DB.graphType.asNode();
    public static Node_URI graphLSet = (Node_URI)DB.graphLSet.asNode();
    public static Node_URI graphPrefix = (Node_URI)DB.graphPrefix.asNode();
    public static Node_URI graphId = (Node_URI)DB.graphId.asNode();
    public static Node_URI stmtTable = (Node_URI)DB.stmtTable.asNode();
    public static Node_URI reifTable = (Node_URI)DB.reifTable.asNode();

    public DBPropGraph(SpecializedGraph g, String symbolicName, String type) {
        super(g);
        this.putPropString(graphName, symbolicName);
        this.putPropString(graphType, type);
    }

    public DBPropGraph(SpecializedGraph g, Node n) {
        super(g, n);
    }

    public DBPropGraph(SpecializedGraph g, String newSymbolicName, Graph oldProperties) {
        super(g);
        this.putPropString(graphName, newSymbolicName);
        ExtendedIterator it = oldProperties.find(Node.ANY, Node.ANY, Node.ANY);
        while (it.hasNext()) {
            Triple t = (Triple)it.next();
            if (t.getPredicate().equals(graphName) || t.getPredicate().equals(graphId) || t.getPredicate().equals(stmtTable) || t.getPredicate().equals(reifTable)) continue;
            this.putPropNode((Node_URI)t.getPredicate(), t.getObject());
        }
    }

    public void addLSet(DBPropLSet lset) {
        this.putPropNode(graphLSet, lset.getNode());
    }

    public void addPrefix(DBPropPrefix prefix) {
        DBPropPrefix existing = this.getPrefix(prefix.getValue());
        if (existing != null) {
            this.removePrefix(existing);
        }
        if ((existing = this.getURI(prefix.getURI())) != null && !prefix.getValue().equals("")) {
            this.removePrefix(existing);
        }
        this.putPropNode(graphPrefix, prefix.getNode());
    }

    public void removePrefix(DBPropPrefix prefix) {
        SpecializedGraph.CompletionFlag complete = DBPropGraph.newComplete();
        ExtendedIterator matches = this.graph.find(this.self, graphPrefix, prefix.getNode(), complete);
        if (matches.hasNext()) {
            this.graph.delete((Triple)matches.next(), complete);
            prefix.remove();
        }
    }

    public void addPrefix(String prefix, String uri) {
        this.addPrefix(new DBPropPrefix(this.graph, prefix, uri));
    }

    public void removePrefix(String prefix) {
        DBPropPrefix existing = this.getPrefix(prefix);
        if (existing != null) {
            this.removePrefix(existing);
        }
    }

    public void addGraphId(int id) {
        this.putPropString(graphId, Integer.toString(id));
    }

    public void addStmtTable(String table) {
        this.putPropString(stmtTable, table);
    }

    public void addReifTable(String table) {
        this.putPropString(reifTable, table);
    }

    public String getName() {
        return this.getPropString(graphName);
    }

    public String getType() {
        return this.getPropString(graphType);
    }

    public String getStmtTable() {
        return this.getPropString(stmtTable);
    }

    public String getReifTable() {
        return this.getPropString(reifTable);
    }

    public int getGraphId() {
        String i = this.getPropString(graphId);
        return i == null ? -1 : Integer.parseInt(i);
    }

    public ExtendedIterator getAllLSets() {
        return this.graph.find(this.self, graphLSet, null, DBPropGraph.newComplete()).mapWith(new MapToLSet());
    }

    public ExtendedIterator getAllPrefixes() {
        return this.graph.find(this.self, graphPrefix, null, DBPropGraph.newComplete()).mapWith(new MapToPrefix());
    }

    public DBPropPrefix getPrefix(String value) {
        ExtendedIterator prefixes = this.getAllPrefixes();
        while (prefixes.hasNext()) {
            DBPropPrefix prefix = (DBPropPrefix)prefixes.next();
            if (prefix.getValue().compareTo(value) != 0) continue;
            return prefix;
        }
        return null;
    }

    public DBPropPrefix getURI(String uri) {
        ExtendedIterator prefixes = this.getAllPrefixes();
        while (prefixes.hasNext()) {
            DBPropPrefix prefix = (DBPropPrefix)prefixes.next();
            if (prefix.getURI().compareTo(uri) != 0) continue;
            return prefix;
        }
        return null;
    }

    public ExtendedIterator listTriples() {
        ExtendedIterator result = DBProp.listTriples(this.graph, this.self);
        ExtendedIterator lsets = this.getAllLSets();
        while (lsets.hasNext()) {
            result = result.andThen(((DBPropLSet)lsets.next()).listTriples());
        }
        ExtendedIterator prefixes = this.getAllPrefixes();
        while (prefixes.hasNext()) {
            result = result.andThen(((DBPropPrefix)prefixes.next()).listTriples());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBPropGraph findPropGraphByName(SpecializedGraph graph, String name) {
        Node myNode = Node.createLiteral(name);
        ExtendedIterator it = graph.find(null, graphName, myNode, DBPropGraph.newComplete());
        if (it.hasNext()) {
            try {
                DBPropGraph dBPropGraph = new DBPropGraph(graph, ((Triple)it.next()).getSubject());
                return dBPropGraph;
            }
            finally {
                it.close();
            }
        }
        return null;
    }

    public boolean isDBPropGraphOk(String name) {
        String s = this.getName();
        boolean res = s == null ? false : s.equals(name);
        res &= this.getGraphId() != -1;
        res &= this.getType() != null;
        res &= this.getStmtTable() != null;
        return res &= this.getReifTable() != null;
    }

    public void remove() {
        ExtendedIterator it = this.getAllPrefixes();
        while (it.hasNext()) {
            ((DBPropPrefix)it.next()).remove();
        }
        it = this.getAllLSets();
        while (it.hasNext()) {
            ((DBPropLSet)it.next()).remove();
        }
        super.remove();
    }

    private class MapToPrefix
    implements Map1 {
        private MapToPrefix() {
        }

        public Object map1(Object o) {
            Triple t = (Triple)o;
            return new DBPropPrefix(DBPropGraph.this.graph, t.getObject());
        }
    }

    private class MapToLSet
    implements Map1 {
        private MapToLSet() {
        }

        public Object map1(Object o) {
            Triple t = (Triple)o;
            return new DBPropLSet(DBPropGraph.this.graph, t.getObject());
        }
    }
}

