/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.db.impl;

import java.util.ArrayList;
import java.util.Iterator;
import mx.com.hp.hpl.jena.db.GraphRDB;
import mx.com.hp.hpl.jena.db.impl.DBPattern;
import mx.com.hp.hpl.jena.db.impl.DBQueryStage;
import mx.com.hp.hpl.jena.db.impl.SpecializedGraph;
import mx.com.hp.hpl.jena.db.impl.VarDesc;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.ExpressionSet;
import mx.com.hp.hpl.jena.graph.query.Mapping;
import mx.com.hp.hpl.jena.graph.query.Pipe;
import mx.com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import mx.com.hp.hpl.jena.graph.query.Stage;
import mx.com.hp.hpl.jena.shared.JenaException;

public class DBQueryHandler
extends SimpleQueryHandler {
    private GraphRDB graph;
    boolean queryOnlyStmt;
    boolean queryOnlyReif;
    boolean queryFullReif;
    private boolean doFastpath;
    private boolean doImplicitJoin;

    public DBQueryHandler(GraphRDB graph) {
        super(graph);
        this.graph = graph;
        if (graph.reificationBehavior() == 1) {
            this.queryOnlyStmt = false;
            this.queryOnlyReif = false;
            this.queryFullReif = false;
        } else {
            this.queryOnlyReif = false;
            this.queryFullReif = false;
            this.queryOnlyStmt = true;
        }
        this.doFastpath = true;
    }

    public void setDoFastpath(boolean val) {
        this.doFastpath = val;
    }

    public boolean getDoFastpath() {
        return this.doFastpath;
    }

    public void setDoImplicitJoin(boolean val) {
        this.doImplicitJoin = val;
    }

    public Stage patternStage(Mapping varMap, ExpressionSet constraints, Triple[] ptn) {
        int i;
        final Stage[] stages = new Stage[ptn.length];
        int stageCnt = 0;
        DBPattern[] source = new DBPattern[ptn.length];
        ArrayList<Integer> patternsToDo = new ArrayList<Integer>();
        for (i = 0; i < ptn.length; ++i) {
            patternsToDo.add(new Integer(i));
        }
        int reifBehavior = this.graph.reificationBehavior();
        if (patternsToDo.size() == 1 && !constraints.isComplex() || !this.doFastpath) {
            for (i = 0; i < patternsToDo.size(); ++i) {
                stages[stageCnt++] = super.patternStage(varMap, constraints, new Triple[]{ptn[i]});
            }
        } else {
            DBPattern src;
            for (i = 0; i < ptn.length; ++i) {
                Triple pat = ptn[i];
                src = new DBPattern(pat, varMap);
                Iterator it = this.graph.getSpecializedGraphs();
                while (it.hasNext()) {
                    SpecializedGraph sg = (SpecializedGraph)it.next();
                    char sub = sg.subsumes(pat, reifBehavior);
                    if (sub == 'n') continue;
                    src.sourceAdd(sg, sub);
                    if (sub != 'a') continue;
                    break;
                }
                source[i] = src;
            }
            DBPattern unstaged = null;
            boolean isConnected = false;
            while (patternsToDo.size() > 0) {
                int minConnCost = 100;
                int minCost = 100;
                isConnected = false;
                DBPattern minSrc = null;
                int minIx = -1;
                for (i = 0; i < patternsToDo.size(); ++i) {
                    unstaged = source[(Integer)patternsToDo.get(i)];
                    int cost = unstaged.cost(varMap);
                    if (unstaged.isConnected) {
                        if (cost >= minConnCost) continue;
                        minSrc = unstaged;
                        minConnCost = cost;
                        isConnected = true;
                        minIx = i;
                        continue;
                    }
                    if (cost >= minCost || isConnected) continue;
                    minCost = cost;
                    minSrc = unstaged;
                    minIx = i;
                }
                if (minSrc == null) {
                    src = unstaged;
                    minIx = i - 1;
                } else {
                    src = minSrc;
                }
                src.isStaged = true;
                patternsToDo.remove(minIx);
                ArrayList varList = new ArrayList();
                ExpressionSet evalCons = new ExpressionSet();
                ArrayList<DBPattern> qryPat = new ArrayList<DBPattern>();
                qryPat.add(src);
                boolean doQuery = false;
                boolean didJoin = false;
                if (src.isSingleSource()) {
                    VarDesc vx;
                    boolean foundJoin;
                    src.addFreeVars(varList);
                    do {
                        foundJoin = false;
                        for (i = 0; i < patternsToDo.size(); ++i) {
                            unstaged = source[(Integer)patternsToDo.get(i)];
                            if (!unstaged.joinsWith(src, varList, this.queryOnlyStmt, this.queryOnlyReif, this.doImplicitJoin)) continue;
                            qryPat.add(unstaged);
                            patternsToDo.remove(i);
                            unstaged.addFreeVars(varList);
                            unstaged.isStaged = true;
                            didJoin = true;
                            foundJoin = true;
                        }
                    } while (foundJoin && patternsToDo.size() > 0);
                    if (didJoin) {
                        doQuery = true;
                    } else {
                        for (i = 0; i < varList.size(); ++i) {
                            vx = (VarDesc)varList.get(i);
                            if (vx.isArgVar || !this.findConstraints(constraints, evalCons, vx)) continue;
                            doQuery = true;
                        }
                    }
                    if (doQuery) {
                        for (i = 0; i < varList.size(); ++i) {
                            vx = (VarDesc)varList.get(i);
                            if (vx.isArgVar) continue;
                            vx.bindToVarMap(varMap);
                        }
                    }
                } else if (!src.hasSource()) {
                    doQuery = true;
                }
                stages[stageCnt] = doQuery ? new DBQueryStage(this.graph, src.hasSource() ? src.singleSource() : null, varList, qryPat, evalCons) : super.patternStage(varMap, constraints, new Triple[]{src.pattern});
                ++stageCnt;
            }
        }
        final Integer numStages = new Integer(stageCnt);
        return new Stage(){

            public Stage connectFrom(Stage s) {
                for (int i = 0; i < numStages; ++i) {
                    stages[i].connectFrom(s);
                    s = stages[i];
                }
                return super.connectFrom(s);
            }

            public Pipe deliver(Pipe L) {
                return stages[numStages - 1].deliver(L);
            }
        };
    }

    public void setQueryOnlyAsserted(boolean opt) {
        if (opt && this.queryOnlyReif) {
            throw new JenaException("QueryOnlyAsserted and QueryOnlyReif cannot both be true");
        }
        this.queryOnlyStmt = opt;
    }

    public boolean getQueryOnlyAsserted() {
        return this.queryOnlyStmt;
    }

    public void setQueryOnlyReified(boolean opt) {
        if (this.graph.reificationBehavior() != 1) {
            throw new JenaException("Reified statements cannot be queried for this model's reification style");
        }
        if (opt && this.queryOnlyStmt) {
            throw new JenaException("QueryOnlyAsserted and QueryOnlyReif cannot both be true");
        }
        this.queryOnlyReif = opt;
    }

    public boolean getQueryOnlyReified() {
        return this.queryOnlyReif;
    }

    public void setQueryFullReified(boolean opt) {
        if (this.graph.reificationBehavior() != 1) {
            throw new JenaException("Reified statements cannot be queried for this model's reification style");
        }
        this.queryFullReif = opt;
    }

    public boolean getQueryFullReified() {
        return this.queryFullReif;
    }

    private boolean findConstraints(ExpressionSet constraints, ExpressionSet evalCons, VarDesc vx) {
        boolean res = false;
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            String f;
            Expression l;
            Expression e = (Expression)it.next();
            if (!e.isApply() || e.argCount() != 2 || !(l = e.getArg(0)).isVariable() || !vx.var.getName().equals(l.getName()) || !(f = e.getFun()).equals("urn:x-jena:expr:J_startsWith") && !f.equals("urn:x-jena:expr:J_startsWithInsensitive") && !f.equals("urn:x-jena:expr:J_contains") && !f.equals("urn:x-jena:expr:J_containsInsensitive") && !f.equals("urn:x-jena:expr:J_endsWith") && !f.equals("urn:x-jena:expr:J_endsWithInsensitive")) continue;
            evalCons.add(e);
            res = true;
        }
        return res;
    }
}

