/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.db.impl;

import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.db.impl.DBPattern;
import mx.com.hp.hpl.jena.db.impl.DBQuery;
import mx.com.hp.hpl.jena.db.impl.DBQueryHandler;
import mx.com.hp.hpl.jena.db.impl.Free;
import mx.com.hp.hpl.jena.db.impl.SpecializedGraph;
import mx.com.hp.hpl.jena.db.impl.VarDesc;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.query.Element;
import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.ExpressionSet;
import mx.com.hp.hpl.jena.graph.query.Fixed;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DBQueryStageCompiler {
    protected static Log logger = LogFactory.getLog((Class)DBQueryStageCompiler.class);

    public static DBQuery compile(DBQueryStageCompiler compiler, DBQueryHandler qh, SpecializedGraph sg, List varList, List dbPat, ExpressionSet constraints) {
        DBQuery query2 = new DBQuery(sg, varList, qh.queryOnlyStmt, qh.queryOnlyReif, qh.queryFullReif);
        if (qh.getQueryOnlyReified() && !qh.getQueryFullReified()) {
            throw new JenaException("Fastpath currently requires QueryFullReified to be true if QueryOnlyReified is also true");
        }
        if (!query2.isEmpty) {
            for (int i = 0; i < dbPat.size(); ++i) {
                DBQueryStageCompiler.compilePattern(compiler, query2, (DBPattern)dbPat.get(i));
            }
            DBQueryStageCompiler.compileConstraints(compiler, query2, constraints);
            DBQueryStageCompiler.compileQuery(compiler, query2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("generated SQL: " + query2.stmt));
        }
        return query2;
    }

    private static void compilePattern(DBQueryStageCompiler compiler, DBQuery query2, DBPattern dbpat) {
        Element subj = dbpat.S;
        Element obj = dbpat.O;
        Element pred = dbpat.P;
        String qual = "";
        int alias = query2.aliasCnt;
        if (query2.isReifier) {
            char reifProp;
            boolean newAlias = true;
            if (!(pred instanceof Fixed)) {
                throw new JenaException("Reifier predicate not bound");
            }
            Node p = ((Fixed)pred).asNodeMatch(null);
            if (p.equals(RDF.Nodes.subject)) {
                reifProp = 'S';
            } else if (p.equals(RDF.Nodes.predicate)) {
                reifProp = 'P';
            } else if (p.equals(RDF.Nodes.object)) {
                reifProp = 'O';
            } else if (p.equals(RDF.Nodes.type)) {
                reifProp = 'T';
            } else {
                throw new JenaException("Unexpected reifier predicate");
            }
            if (!subj.equals(Element.ANY)) {
                if (query2.qryFullReif && subj instanceof Free && query2.getBinding(((Free)subj).getListing()).isBoundToCol()) {
                    alias = query2.getBinding((int)((Free)subj).getListing()).alias;
                    newAlias = false;
                } else {
                    qual = query2.sqlAnd.gen(DBQueryStageCompiler.getQual(query2, alias, 'N', subj));
                }
            }
            qual = qual + query2.sqlAnd.gen(DBQueryStageCompiler.getQual(query2, alias, reifProp, obj));
            qual = qual + query2.sqlAnd.gen(query2.driver.genSQLQualGraphId(alias, query2.graphId));
            if (newAlias) {
                query2.newAlias();
            }
        } else {
            qual = query2.sqlAnd.gen(DBQueryStageCompiler.getQual(query2, alias, 'S', subj));
            qual = qual + query2.sqlAnd.gen(DBQueryStageCompiler.getQual(query2, alias, 'P', pred));
            qual = qual + query2.sqlAnd.gen(DBQueryStageCompiler.getQual(query2, alias, 'O', obj));
            qual = qual + query2.sqlAnd.gen(query2.driver.genSQLQualGraphId(alias, query2.graphId));
            query2.newAlias();
        }
        query2.stmt = query2.stmt + qual;
    }

    private static String getQual(DBQuery query2, int alias, char pred, Element spo) {
        String qual = "";
        if (spo instanceof Fixed) {
            Node obj = ((Fixed)spo).asNodeMatch(null);
            qual = query2.isReifier ? query2.driver.genSQLReifQualConst(alias, pred, obj) : query2.driver.genSQLQualConst(alias, pred, obj);
        } else if (spo instanceof Free) {
            Free v = (Free)spo;
            VarDesc bind = query2.getBinding(v.getListing());
            if (v.isArg() && !bind.isBoundToCol) {
                ++query2.argCnt;
                query2.argType = query2.argType + pred;
                query2.argIndex.add(new Integer(v.getMapping()));
                qual = query2.driver.genSQLQualParam(alias, pred);
                bind.bindToCol(alias, pred);
            } else if (bind.isBoundToCol()) {
                qual = query2.driver.genSQLJoin(bind.alias, bind.column, alias, pred);
            } else {
                bind.bindToCol(alias, pred);
                qual = "";
            }
        } else if (spo != Element.ANY) {
            throw new JenaException("Invalid Element in qualifier");
        }
        return qual;
    }

    private static void compileConstraints(DBQueryStageCompiler compiler, DBQuery query2, ExpressionSet constraints) {
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            VarDesc bind = query2.findBinding(e.getArg(0).getName());
            if (bind == null) {
                throw new JenaException("Unbound variable in constraint");
            }
            String strMat = ((Expression.Fixed)e.getArg(1)).toString();
            query2.stmt = query2.stmt + query2.sqlAnd.gen(query2.driver.genSQLStringMatch(bind.alias, bind.column, e.getFun(), strMat));
        }
    }

    private static void compileQuery(DBQueryStageCompiler compiler, DBQuery query2) {
        int resCnt = query2.vars.length - query2.argCnt;
        query2.resList = new int[resCnt];
        query2.stmt = query2.driver.genSQLSelectStmt(query2.driver.genSQLResList(query2.resList, query2.vars), query2.driver.genSQLFromList(query2.aliasCnt, query2.table), query2.stmt);
    }
}

