/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.db.impl;

import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.db.GraphRDB;
import mx.com.hp.hpl.jena.db.impl.SpecializedGraph;
import mx.com.hp.hpl.jena.graph.BulkUpdateHandler;
import mx.com.hp.hpl.jena.graph.Capabilities;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.GraphEventManager;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Reifier;
import mx.com.hp.hpl.jena.graph.TransactionHandler;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.TripleMatch;
import mx.com.hp.hpl.jena.graph.impl.GraphBase;
import mx.com.hp.hpl.jena.graph.impl.GraphMatcher;
import mx.com.hp.hpl.jena.graph.query.QueryHandler;
import mx.com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import mx.com.hp.hpl.jena.shared.AddDeniedException;
import mx.com.hp.hpl.jena.shared.BrokenException;
import mx.com.hp.hpl.jena.shared.ClosedException;
import mx.com.hp.hpl.jena.shared.DeleteDeniedException;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.shared.PrefixMapping;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.NiceIterator;

public class DBReifierGraph
implements Graph {
    protected List m_specializedGraphs = null;
    protected GraphRDB m_parent = null;

    public DBReifierGraph(GraphRDB parent, List reifiers) {
        this.m_parent = parent;
        this.m_specializedGraphs = reifiers;
    }

    public void add(Triple t) {
        throw new AddDeniedException("cannot add to DB reifier", t);
    }

    public void delete(Triple t) {
        throw new DeleteDeniedException("cannot delete from a DB reifier", t);
    }

    public int size() {
        this.checkUnclosed();
        int result = 0;
        Iterator it = this.m_specializedGraphs.iterator();
        while (it.hasNext()) {
            SpecializedGraph sg = (SpecializedGraph)it.next();
            result += sg.tripleCount();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void checkUnclosed() {
        if (this.m_specializedGraphs == null) {
            throw new ClosedException("this DB Reifier has been closed", this);
        }
    }

    public boolean contains(Triple t) {
        this.checkUnclosed();
        SpecializedGraph.CompletionFlag complete = this.newComplete();
        Iterator it = this.m_specializedGraphs.iterator();
        while (it.hasNext()) {
            SpecializedGraph sg = (SpecializedGraph)it.next();
            boolean result = sg.contains(t, this.newComplete());
            if (!result && !complete.isDone()) continue;
            return result;
        }
        return false;
    }

    protected SpecializedGraph.CompletionFlag newComplete() {
        return new SpecializedGraph.CompletionFlag();
    }

    public boolean contains(Node s, Node p, Node o) {
        return this.contains(Triple.create(s, p, o));
    }

    public ExtendedIterator find(TripleMatch m) {
        this.checkUnclosed();
        ExtendedIterator result = new NiceIterator();
        SpecializedGraph.CompletionFlag complete = this.newComplete();
        Iterator it = this.m_specializedGraphs.iterator();
        while (it.hasNext()) {
            SpecializedGraph sg = (SpecializedGraph)it.next();
            ExtendedIterator partialResult = sg.find(m, complete);
            result = result.andThen(partialResult);
            if (!complete.isDone()) continue;
            break;
        }
        return result;
    }

    public PrefixMapping getPrefixMapping() {
        return this.m_parent.getPrefixMapping();
    }

    public TransactionHandler getTransactionHandler() {
        return this.m_parent.getTransactionHandler();
    }

    public void close() {
        this.m_specializedGraphs = null;
        this.m_parent = null;
    }

    public GraphEventManager getEventManager() {
        throw new BrokenException("DB reifiers do not yet implement getEventManager");
    }

    public boolean dependsOn(Graph other) {
        return this.m_parent.dependsOn(other);
    }

    public QueryHandler queryHandler() {
        return new SimpleQueryHandler(this);
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        return this.m_parent.getBulkUpdateHandler();
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public Reifier getReifier() {
        throw new JenaException("DB Reifier graphs have no reifiers");
    }

    public ExtendedIterator find(Node s, Node p, Node o) {
        return this.find(Triple.createMatch(s, p, o));
    }

    public boolean isIsomorphicWith(Graph g) {
        return g != null && GraphMatcher.equals(this, g);
    }

    public int capabilities() {
        return 0;
    }

    public String toString() {
        return GraphBase.toString("DBReifier ", this);
    }
}

