/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.db.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import mx.com.hp.hpl.jena.db.IDBConnection;
import mx.com.hp.hpl.jena.db.RDFRDBException;
import mx.com.hp.hpl.jena.db.impl.DBIDInt;
import mx.com.hp.hpl.jena.db.impl.DriverRDB;
import mx.com.hp.hpl.jena.db.impl.SQLCache;

public class Driver_MySQL
extends DriverRDB {
    public Driver_MySQL() {
        String myPackageName = this.getClass().getPackage().getName();
        this.DATABASE_TYPE = "MySQL";
        this.DRIVER_NAME = "com.mysql.jdbc.Driver";
        this.ID_SQL_TYPE = "INTEGER";
        this.URI_COMPRESS = false;
        this.INDEX_KEY_LENGTH = 250;
        this.INDEX_KEY_LENGTH_MAX = 250;
        this.LONG_OBJECT_LENGTH = 250;
        this.LONG_OBJECT_LENGTH_MAX = 250;
        this.TABLE_NAME_LENGTH_MAX = 64;
        this.IS_XACT_DB = true;
        this.PRE_ALLOCATE_ID = false;
        this.SKIP_DUPLICATE_CHECK = false;
        this.SQL_FILE = "etc/mysql.sql";
        this.DB_NAMES_TO_UPPER = false;
        this.setTableNames(this.TABLE_NAME_PREFIX);
        this.QUOTE_CHAR = (char)39;
        this.m_psetClassName = myPackageName + ".PSet_TripleStore_RDB";
        this.m_psetReifierClassName = myPackageName + ".PSet_ReifStore_RDB";
        this.m_lsetClassName = myPackageName + ".SpecializedGraph_TripleStore_RDB";
        this.m_lsetReifierClassName = myPackageName + ".SpecializedGraphReifier_RDB";
    }

    public void setConnection(IDBConnection dbcon) {
        this.m_dbcon = dbcon;
        try {
            this.m_sql = new SQLCache(this.SQL_FILE, null, dbcon, this.ID_SQL_TYPE);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            logger.error((Object)"Unable to set connection for Driver:", (Throwable)e);
        }
    }

    public int graphIdAlloc(String graphName) {
        Object result = null;
        int dbid = 0;
        try {
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement("insertGraph", this.GRAPH_TABLE);
            ps.setString(1, graphName);
            ps.executeUpdate();
            dbid = this.getInsertID(this.GRAPH_TABLE);
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to get last inserted ID: " + e);
        }
        return dbid;
    }

    public void graphIdDealloc(int graphId) {
        Object result = null;
        try {
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement("deleteGraph", this.GRAPH_TABLE);
            ps.setInt(1, graphId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to delete graph ID: " + e);
        }
    }

    public int getInsertID(String tableName) {
        DBIDInt result = null;
        try {
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement("getInsertID");
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                throw new RDFRDBException("No last insert ID");
            }
            result = this.wrapDBID(rs.getObject(1));
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to get last inserted ID: " + e);
        }
        return result.getIntID();
    }

    protected void getTblParams(String[] param) {
        String headColType;
        String objColType;
        String tblImpl;
        String spoKeyLen = Integer.toString(this.LONG_OBJECT_LENGTH);
        String headKeyLen = Integer.toString(this.INDEX_KEY_LENGTH);
        if (this.INDEX_KEY_LENGTH > 250) {
            throw new RDFRDBException("Key length specified (" + this.INDEX_KEY_LENGTH + ") exceeds MySQL maximum key length of 250.");
        }
        String string = tblImpl = this.IS_XACT_DB ? "INNODB" : "MyISAM";
        if (this.IS_XACT_DB) {
            if (this.LONG_OBJECT_LENGTH > 250) {
                throw new RDFRDBException("Long object length specified (" + this.LONG_OBJECT_LENGTH + ") exceeds MySQL maximum VARCHAR length of 250.");
            }
            objColType = "VARCHAR(" + this.LONG_OBJECT_LENGTH + ") BINARY";
            this.STRINGS_TRIMMED = true;
            this.EOS = ":";
        } else {
            objColType = this.LONG_OBJECT_LENGTH <= 250 ? "TINYBLOB" : "MEDIUMBLOB";
            this.STRINGS_TRIMMED = false;
            this.EOS = "";
        }
        if (this.IS_XACT_DB) {
            if (this.INDEX_KEY_LENGTH > 250) {
                throw new RDFRDBException("Index key length specified (" + this.INDEX_KEY_LENGTH + ") exceeds MySQL maximum VARCHAR length of 250.");
            }
            headColType = "VARCHAR(" + this.INDEX_KEY_LENGTH + ") BINARY";
        } else {
            headColType = this.INDEX_KEY_LENGTH <= 250 ? "TINYBLOB" : "MEDIUMBLOB";
        }
        param[0] = objColType;
        param[1] = tblImpl;
        param[2] = spoKeyLen;
        param[3] = headColType;
        param[4] = headKeyLen;
        param[5] = this.TABLE_NAME_PREFIX;
    }

    protected String[] getDbInitTablesParams() {
        String[] res = new String[6];
        this.getTblParams(res);
        if (this.IS_XACT_DB) {
            this.STRINGS_TRIMMED = true;
            this.EOS = ":";
        } else {
            this.STRINGS_TRIMMED = false;
            this.EOS = "";
        }
        this.EOS_LEN = this.EOS.length();
        return res;
    }

    protected String[] getCreateTableParams(int graphId, boolean isReif) {
        String[] parms = new String[6];
        String[] res = new String[4];
        this.getTblParams(parms);
        int tblCnt = this.getTableCount(graphId);
        res[0] = this.genTableName(graphId, tblCnt, isReif);
        res[1] = parms[0];
        res[2] = parms[1];
        res[3] = parms[2];
        return res;
    }

    public String genSQLStringMatchLHS_IC(String var) {
        return "cast(" + var + " as char)";
    }
}

