/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.db.impl;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Node_Variable;
import mx.com.hp.hpl.jena.graph.query.Mapping;
import mx.com.hp.hpl.jena.shared.JenaException;

public class VarDesc {
    Node_Variable var;
    boolean isArgVar;
    boolean isBoundToCol;
    int resIx;
    int mapIx;
    int alias;
    char column;

    public VarDesc(Node v, int mapix, int resix) {
        this.var = (Node_Variable)v;
        this.isArgVar = true;
        this.mapIx = mapix;
        this.resIx = resix;
        this.isBoundToCol = false;
    }

    public VarDesc(Node v, int resix) {
        this.var = (Node_Variable)v;
        this.isArgVar = false;
        this.mapIx = -1;
        this.resIx = resix;
        this.isBoundToCol = false;
    }

    public void bindToVarMap(Mapping varMap) {
        if (this.isArgVar) {
            throw new JenaException("Variable bound twice to argument");
        }
        this.mapIx = varMap.newIndex(this.var);
    }

    public void bindToCol(int tblAlias, char colId) {
        if (this.isBoundToCol) {
            throw new JenaException("Variable bound twice to column");
        }
        this.isBoundToCol = true;
        this.alias = tblAlias;
        this.column = colId;
    }

    public boolean isBoundToCol() {
        return this.isBoundToCol;
    }

    public boolean isArgVar() {
        return this.isArgVar;
    }
}

