/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.enhanced;

import mx.com.hp.hpl.jena.enhanced.EnhGraph;
import mx.com.hp.hpl.jena.enhanced.GraphPersonality;
import mx.com.hp.hpl.jena.enhanced.Implementation;
import mx.com.hp.hpl.jena.enhanced.Personality;
import mx.com.hp.hpl.jena.enhanced.Polymorphic;
import mx.com.hp.hpl.jena.enhanced.UnsupportedPolymorphismException;
import mx.com.hp.hpl.jena.graph.FrontsNode;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;

public class EnhNode
extends Polymorphic
implements FrontsNode {
    protected final Node node;
    protected final EnhGraph enhGraph;

    public EnhNode(Node n, EnhGraph g) {
        this.node = n;
        this.enhGraph = g;
    }

    public Node asNode() {
        return this.node;
    }

    public EnhGraph getGraph() {
        return this.enhGraph;
    }

    public final boolean isAnon() {
        return this.node.isBlank();
    }

    public final boolean isLiteral() {
        return this.node.isLiteral();
    }

    public final boolean isURIResource() {
        return this.node.isURI();
    }

    public final boolean isResource() {
        return this.node.isURI() || this.node.isBlank();
    }

    public EnhNode viewAs(Class t) {
        return (EnhNode)this.asInternal(t);
    }

    public RDFNode as(Class t) {
        return (RDFNode)((Object)this.viewAs(t));
    }

    public boolean canAs(Class t) {
        return this.canSupport(t);
    }

    public final int hashCode() {
        return this.node.hashCode();
    }

    public final boolean equals(Object o) {
        return o instanceof FrontsNode && this.node.equals(((FrontsNode)o).asNode());
    }

    public boolean isValid() {
        return true;
    }

    protected Polymorphic convertTo(Class t) {
        EnhGraph eg = this.getGraph();
        Implementation imp = this.getPersonality().getImplementation(t);
        if (imp == null) {
            throw new UnsupportedPolymorphismException(eg, t);
        }
        EnhNode result = imp.wrap(this.asNode(), eg);
        this.addView(result);
        return result;
    }

    protected boolean canSupport(Class t) {
        Implementation imp = this.getPersonality().getImplementation(t);
        return imp == null ? false : imp.canWrap(this.asNode(), this.getGraph());
    }

    protected Personality getPersonality() {
        return ((GraphPersonality)this.getGraph().getPersonality()).nodePersonality();
    }
}

