/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph;

import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.mem.GraphMem;
import mx.com.hp.hpl.jena.mem.faster.GraphMemFaster;
import mx.com.hp.hpl.jena.shared.ReificationStyle;

public class Factory {
    public static boolean faster = System.getProperty("jena.faster", "yes").equals("yes");

    private Factory() {
    }

    public static Graph createDefaultGraph() {
        return Factory.createDefaultGraph(ReificationStyle.Standard);
    }

    public static Graph createDefaultGraph(ReificationStyle style) {
        return Factory.createGraphMem(style);
    }

    public static Graph createGraphMem() {
        return faster ? new GraphMemFaster() : new GraphMem();
    }

    public static Graph createGraphMem(ReificationStyle style) {
        return faster ? new GraphMemFaster(style) : new GraphMem(style);
    }
}

