/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph;

import mx.com.hp.hpl.jena.graph.GetTriple;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.TripleMatch;
import mx.com.hp.hpl.jena.shared.ReificationStyle;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.vocabulary.RDF;

public interface Reifier
extends GetTriple {
    public ExtendedIterator find(TripleMatch var1);

    public ExtendedIterator findExposed(TripleMatch var1);

    public ExtendedIterator findEither(TripleMatch var1, boolean var2);

    public int size();

    public ReificationStyle getStyle();

    public Graph getParentGraph();

    public Node reifyAs(Node var1, Triple var2);

    public boolean hasTriple(Node var1);

    public boolean hasTriple(Triple var1);

    public ExtendedIterator allNodes();

    public ExtendedIterator allNodes(Triple var1);

    public void remove(Node var1, Triple var2);

    public void remove(Triple var1);

    public boolean handledAdd(Triple var1);

    public boolean handledRemove(Triple var1);

    public void close();

    public static class Util {
        public static boolean isReificationPredicate(Node node) {
            return node.equals(RDF.Nodes.subject) || node.equals(RDF.Nodes.predicate) || node.equals(RDF.Nodes.object);
        }

        public static boolean couldBeStatement(Node node) {
            return node.isVariable() || node.equals(Node.ANY) || node.equals(RDF.Nodes.Statement);
        }

        public static boolean isReificationType(Node P, Node O) {
            return P.equals(RDF.Nodes.type) && Util.couldBeStatement(O);
        }
    }
}

