/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.compose;

import java.util.Set;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.GraphUtil;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.impl.GraphBase;
import mx.com.hp.hpl.jena.util.IteratorCollection;
import mx.com.hp.hpl.jena.util.iterator.ClosableIterator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.Filter;
import mx.com.hp.hpl.jena.util.iterator.FilterIterator;
import mx.com.hp.hpl.jena.util.iterator.NiceIterator;

public abstract class CompositionBase
extends GraphBase {
    public int graphBaseSize() {
        return CompositionBase.countIterator(GraphUtil.findAll(this));
    }

    protected void die(String message) {
        throw new UnsupportedOperationException(message);
    }

    public static Filter reject(ClosableIterator i) {
        final Set suppress = IteratorCollection.iteratorToSet(i);
        return new Filter(){

            public boolean accept(Object o) {
                return !suppress.contains(o);
            }
        };
    }

    public static ClosableIterator butNot(ClosableIterator a, ClosableIterator b) {
        return new FilterIterator(CompositionBase.reject(b), a);
    }

    public static ExtendedIterator recording(final ClosableIterator i, final Set seen) {
        return new NiceIterator(){

            public void remove() {
                i.remove();
            }

            public boolean hasNext() {
                return i.hasNext();
            }

            public Object next() {
                Object x = i.next();
                seen.add(x);
                return x;
            }

            public void close() {
                i.close();
            }
        };
    }

    public static ExtendedIterator rejecting(ExtendedIterator i, final Set seen) {
        Filter seenFilter = new Filter(){

            public boolean accept(Object x) {
                return seen.contains(x);
            }
        };
        return i.filterDrop(seenFilter);
    }

    public static ExtendedIterator rejecting(ExtendedIterator i, final Graph seen) {
        Filter seenFilter = new Filter(){

            public boolean accept(Object x) {
                return seen.contains((Triple)x);
            }
        };
        return i.filterDrop(seenFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countIterator(ClosableIterator i) {
        try {
            int n = 0;
            while (i.hasNext()) {
                ++n;
                i.next();
            }
            int n2 = n;
            return n2;
        }
        finally {
            i.close();
        }
    }

    public static Filter ifIn(ClosableIterator i) {
        final Set allow = IteratorCollection.iteratorToSet(i);
        return new Filter(){

            public boolean accept(Object x) {
                return allow.contains(x);
            }
        };
    }

    public static Filter ifIn(final Graph g) {
        return new Filter(){

            public boolean accept(Object x) {
                return g.contains((Triple)x);
            }
        };
    }
}

