/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.compose;

import mx.com.hp.hpl.jena.graph.Factory;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.GraphUtil;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.TripleMatch;
import mx.com.hp.hpl.jena.graph.compose.Dyadic;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class Delta
extends Dyadic
implements Graph {
    private Graph base;

    public Delta(Graph base) {
        super(Factory.createGraphMem(), Factory.createGraphMem());
        this.base = base;
    }

    public Graph getAdditions() {
        return this.L;
    }

    public Graph getDeletions() {
        return this.R;
    }

    public void performAdd(Triple t) {
        this.L.add(t);
        this.R.delete(t);
    }

    public void performDelete(Triple t) {
        this.L.delete(t);
        this.R.add(t);
    }

    public ExtendedIterator graphBaseFind(TripleMatch tm) {
        return this.base.find(tm).filterDrop(Delta.ifIn(GraphUtil.findAll(this.R))).andThen(this.L.find(tm));
    }

    public void close() {
        super.close();
        this.base.close();
    }

    public int graphBaseSize() {
        return this.base.size() + this.L.size() - this.R.size();
    }
}

