/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.compose;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.graph.BulkUpdateHandler;
import mx.com.hp.hpl.jena.graph.Capabilities;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.TransactionHandler;
import mx.com.hp.hpl.jena.graph.compose.CompositionBase;
import mx.com.hp.hpl.jena.graph.compose.PolyadicPrefixMappingImpl;
import mx.com.hp.hpl.jena.graph.impl.WrappedBulkUpdateHandler;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.shared.PrefixMapping;
import mx.com.hp.hpl.jena.util.iterator.ClosableIterator;

public abstract class Polyadic
extends CompositionBase {
    protected List m_subGraphs = new ArrayList();
    protected Graph m_baseGraph = null;
    private PrefixMapping pm;

    public Polyadic() {
    }

    public Polyadic(Graph[] graphs) {
        for (int i = 0; i < graphs.length; ++i) {
            this.m_subGraphs.add(graphs[i]);
        }
    }

    public PrefixMapping getPrefixMapping() {
        if (this.pm == null) {
            this.pm = new PolyadicPrefixMappingImpl(this);
        }
        return this.pm;
    }

    public Polyadic(Iterator graphs) {
        while (graphs.hasNext()) {
            this.m_subGraphs.add(graphs.next());
        }
        if (graphs instanceof ClosableIterator) {
            ((ClosableIterator)graphs).close();
        }
    }

    public void close() {
        Iterator i = this.m_subGraphs.iterator();
        while (i.hasNext()) {
            ((Graph)i.next()).close();
        }
    }

    public boolean dependsOn(Graph graph) {
        return graph == this || this.m_subGraphs.contains(graph);
    }

    public void addGraph(Graph graph) {
        this.m_subGraphs.add(graph);
    }

    public void removeGraph(Graph graph) {
        this.m_subGraphs.remove(graph);
        if (this.m_baseGraph == graph) {
            this.m_baseGraph = null;
        }
    }

    public Graph getBaseGraph() {
        if (this.m_baseGraph == null) {
            return this.m_subGraphs.size() == 0 ? null : (Graph)this.m_subGraphs.get(0);
        }
        return this.m_baseGraph;
    }

    public Graph getRequiredBaseGraph() {
        Graph base = this.getBaseGraph();
        if (base == null) {
            throw new JenaException("This polyadic graph should have a base graph, but none is defined");
        }
        return base;
    }

    public void setBaseGraph(Graph graph) {
        if (!this.m_subGraphs.contains(graph)) {
            throw new IllegalArgumentException("The updateable graph must be one of the graphs from the composition");
        }
        this.m_baseGraph = graph;
        this.bulkHandler = null;
    }

    public List getSubGraphs() {
        ArrayList sg = new ArrayList(this.m_subGraphs);
        if (this.getBaseGraph() != null) {
            sg.remove(this.getBaseGraph());
        }
        return sg;
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new WrappedBulkUpdateHandler(this, this.getRequiredBaseGraph().getBulkUpdateHandler());
        }
        return this.bulkHandler;
    }

    public TransactionHandler getTransactionHandler() {
        return this.getBaseGraph() == null ? super.getTransactionHandler() : this.getBaseGraph().getTransactionHandler();
    }

    public Capabilities getCapabilities() {
        return this.getBaseGraph() == null ? super.getCapabilities() : this.getBaseGraph().getCapabilities();
    }
}

