/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import mx.com.hp.hpl.jena.graph.impl.FileGraph;
import mx.com.hp.hpl.jena.shared.AlreadyExistsException;
import mx.com.hp.hpl.jena.shared.ReificationStyle;
import mx.com.hp.hpl.jena.util.CollectionFactory;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.Map1;
import mx.com.hp.hpl.jena.util.iterator.WrappedIterator;
import mx.com.hp.hpl.jena.vocabulary.JenaModelSpec;

public class FileGraphMaker
extends BaseGraphMaker
implements FileGraph.NotifyOnClose {
    private String fileBase;
    private boolean deleteOnClose;
    private Map created = CollectionFactory.createHashedMap();
    private static Map1 unconvert = new Map1(){

        public Object map1(Object x) {
            return FileGraphMaker.toGraphname((String)x);
        }
    };

    public FileGraphMaker(String root) {
        this(root, ReificationStyle.Minimal);
    }

    public FileGraphMaker(String root, ReificationStyle style) {
        this(root, style, false);
    }

    public FileGraphMaker(String root, ReificationStyle style, boolean deleteOnClose) {
        super(style);
        this.fileBase = root;
        this.deleteOnClose = deleteOnClose;
    }

    public Node getMakerClass() {
        return JenaModelSpec.FileMakerSpec.asNode();
    }

    public String getFileBase() {
        return this.fileBase;
    }

    protected void augmentDescription(Graph g, Node self) {
        g.add(Triple.create(self, JenaModelSpec.fileBase.asNode(), Node.createLiteral(this.fileBase, "", false)));
    }

    public Graph createGraph() {
        return FileGraph.create();
    }

    public Graph createGraph(String name, boolean strict) {
        File f = this.withRoot(name);
        FileGraph already = (FileGraph)this.created.get(f);
        if (already == null) {
            return this.remember(f, new FileGraph(this, f, true, strict, this.style));
        }
        if (strict) {
            throw new AlreadyExistsException(name);
        }
        return already.openAgain();
    }

    public Graph openGraph(String name, boolean strict) {
        File f = this.withRoot(name);
        return this.created.containsKey(f) ? ((FileGraph)this.created.get(f)).openAgain() : this.remember(f, new FileGraph(this, f, false, strict, this.style));
    }

    public void notifyClosed(File f) {
        this.created.remove(f);
    }

    private File withRoot(String name) {
        return new File(this.fileBase, FileGraphMaker.toFilename(name));
    }

    public static String toFilename(String name) {
        return name.replaceAll("_", "_U").replaceAll("/", "_S").replaceAll(":", "_C");
    }

    public static String toGraphname(String fileName) {
        return fileName.replaceAll("_C", ":").replaceAll("_S", "/").replaceAll("_U", "_");
    }

    public void removeGraph(String name) {
        this.forget(this.withRoot(name)).delete();
    }

    private FileGraph remember(File f, FileGraph g) {
        this.created.put(f, g);
        return g;
    }

    private File forget(File f) {
        this.created.remove(f);
        return f;
    }

    public boolean hasGraph(String name) {
        File f = this.withRoot(name);
        return this.created.containsKey(f) || f.exists();
    }

    public void close() {
        if (this.deleteOnClose) {
            Iterator it = this.created.keySet().iterator();
            while (it.hasNext()) {
                ((File)it.next()).delete();
            }
        }
    }

    public static FilenameFilter graphName() {
        return new FilenameFilter(){

            public boolean accept(File file, String name) {
                return !new File(file, name).isDirectory() && FileGraph.isPlausibleGraphName(name);
            }
        };
    }

    public ExtendedIterator listGraphs() {
        String[] fileNames = new File(this.fileBase).list(FileGraphMaker.graphName());
        Set allNames = CollectionFactory.createHashedSet(Arrays.asList(fileNames));
        Iterator it = this.created.keySet().iterator();
        while (it.hasNext()) {
            allNames.add(((File)it.next()).getName());
        }
        return WrappedIterator.create(allNames.iterator()).mapWith(unconvert);
    }
}

