/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.impl;

import java.util.HashMap;
import java.util.Map;
import mx.com.hp.hpl.jena.graph.Factory;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import mx.com.hp.hpl.jena.mem.GraphMemBase;
import mx.com.hp.hpl.jena.shared.AlreadyExistsException;
import mx.com.hp.hpl.jena.shared.DoesNotExistException;
import mx.com.hp.hpl.jena.shared.ReificationStyle;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.WrappedIterator;
import mx.com.hp.hpl.jena.vocabulary.JenaModelSpec;

public class SimpleGraphMaker
extends BaseGraphMaker {
    private Map graphs = new HashMap();

    public SimpleGraphMaker(ReificationStyle style) {
        super(style);
    }

    public SimpleGraphMaker() {
        this(ReificationStyle.Minimal);
    }

    public Node getMakerClass() {
        return JenaModelSpec.MemMakerSpec.asNode();
    }

    protected void augmentDescription(Graph d, Node self) {
    }

    public Graph create() {
        return Factory.createGraphMem();
    }

    public Graph createGraph(String name, boolean strict) {
        GraphMemBase already = (GraphMemBase)this.graphs.get(name);
        if (already == null) {
            Graph result = Factory.createGraphMem(this.style);
            this.graphs.put(name, result);
            return result;
        }
        if (strict) {
            throw new AlreadyExistsException(name);
        }
        return already.openAgain();
    }

    public Graph openGraph(String name, boolean strict) {
        GraphMemBase already = (GraphMemBase)this.graphs.get(name);
        if (already == null) {
            if (strict) {
                throw new DoesNotExistException(name);
            }
            return this.createGraph(name, true);
        }
        return already.openAgain();
    }

    public Graph openGraph() {
        return this.getGraph();
    }

    public void removeGraph(String name) {
        if (!this.graphs.containsKey(name)) {
            throw new DoesNotExistException(name);
        }
        this.graphs.remove(name);
    }

    public boolean hasGraph(String name) {
        return this.graphs.containsKey(name);
    }

    public void close() {
    }

    public ExtendedIterator listGraphs() {
        return WrappedIterator.create(this.graphs.keySet().iterator());
    }
}

