/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.impl;

import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.GraphAdd;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Reifier;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.TripleMatch;
import mx.com.hp.hpl.jena.graph.impl.GraphBase;
import mx.com.hp.hpl.jena.graph.impl.ReifierFragmentHandler;
import mx.com.hp.hpl.jena.graph.impl.ReifierFragmentsMap;
import mx.com.hp.hpl.jena.graph.impl.ReifierTripleMap;
import mx.com.hp.hpl.jena.graph.impl.SimpleReifierFragmentsMap;
import mx.com.hp.hpl.jena.graph.impl.SimpleReifierTripleMap;
import mx.com.hp.hpl.jena.shared.AlreadyReifiedException;
import mx.com.hp.hpl.jena.shared.CannotReifyException;
import mx.com.hp.hpl.jena.shared.ReificationStyle;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.NullIterator;
import mx.com.hp.hpl.jena.vocabulary.RDF;

public class SimpleReifier
implements Reifier {
    protected final GraphBase parent;
    protected final boolean intercepting;
    protected final boolean concealing;
    protected final ReificationStyle style;
    protected ReifierFragmentsMap fragmentsMap;
    protected ReifierTripleMap tripleMap;
    protected boolean closed = false;

    public SimpleReifier(GraphBase parent, ReificationStyle style) {
        this(parent, new SimpleReifierTripleMap(), new SimpleReifierFragmentsMap(), style);
    }

    public SimpleReifier(GraphBase parent, ReifierTripleMap tm, ReifierFragmentsMap fm, ReificationStyle style) {
        this.parent = parent;
        this.fragmentsMap = fm;
        this.tripleMap = tm;
        this.intercepting = style.intercepts();
        this.concealing = style.conceals();
        this.style = style;
    }

    public ReificationStyle getStyle() {
        return this.style;
    }

    public Graph getParentGraph() {
        return this.parent;
    }

    public Triple getTriple(Node n) {
        return this.tripleMap.getTriple(n);
    }

    public boolean hasTriple(Node n) {
        return this.getTriple(n) != null;
    }

    public ExtendedIterator allNodes() {
        return this.tripleMap.tagIterator();
    }

    public ExtendedIterator allNodes(Triple t) {
        return this.tripleMap.tagIterator(t);
    }

    public Node reifyAs(Node tag, Triple toReify) {
        Triple existing = this.tripleMap.getTriple(tag);
        if (existing != null) {
            if (!toReify.equals(existing)) {
                throw new AlreadyReifiedException(tag);
            }
        } else {
            this.reifyNewTriple(tag, toReify);
        }
        if (!this.concealing) {
            SimpleReifier.graphAddQuad(this.parent, tag, toReify);
        }
        return tag;
    }

    protected void reifyNewTriple(Node tag, Triple toReify) {
        if (this.fragmentsMap.hasFragments(tag)) {
            SimpleReifier.graphAddQuad(this.parent, tag, toReify);
            if (this.tripleMap.getTriple(tag) == null) {
                throw new CannotReifyException(tag);
            }
        } else {
            this.tripleMap.putTriple(tag, toReify);
        }
    }

    public void remove(Node n, Triple t) {
        Triple x = this.tripleMap.getTriple(n);
        if (t.equals(x)) {
            this.tripleMap.removeTriple(n, t);
            if (!this.concealing) {
                this.parentRemoveQuad(n, t);
            }
        }
    }

    public void remove(Triple t) {
        this.tripleMap.removeTriple(t);
    }

    public boolean hasTriple(Triple t) {
        return this.tripleMap.hasTriple(t);
    }

    public boolean handledAdd(Triple fragment) {
        if (this.intercepting) {
            ReifierFragmentHandler s = this.fragmentsMap.getFragmentHandler(fragment);
            if (s == null) {
                return false;
            }
            this.addFragment(s, fragment);
            return true;
        }
        return false;
    }

    protected void addFragment(ReifierFragmentHandler s, Triple fragment) {
        Node tag = fragment.getSubject();
        Node object = fragment.getObject();
        Triple reified = this.tripleMap.getTriple(tag);
        if (reified == null) {
            this.updateFragments(s, fragment, tag, object);
        } else if (s.clashedWith(tag, object, reified)) {
            this.tripleMap.removeTriple(tag, reified);
        }
    }

    private void updateFragments(ReifierFragmentHandler s, Triple fragment, Node tag, Node object) {
        Triple t = s.reifyIfCompleteQuad(fragment, tag, object);
        if (t instanceof Triple) {
            this.tripleMap.putTriple(tag, t);
        }
    }

    public boolean handledRemove(Triple fragment) {
        if (this.intercepting) {
            ReifierFragmentHandler s = this.fragmentsMap.getFragmentHandler(fragment);
            if (s == null) {
                return false;
            }
            this.removeFragment(s, fragment);
            return true;
        }
        return false;
    }

    private void removeFragment(ReifierFragmentHandler s, Triple fragment) {
        Triple already;
        Node tag = fragment.getSubject();
        Triple complete = s.removeFragment(tag, already = this.tripleMap.getTriple(tag), fragment);
        if (complete == null) {
            this.tripleMap.removeTriple(tag);
        } else {
            this.tripleMap.putTriple(tag, complete);
        }
    }

    public ExtendedIterator find(TripleMatch m) {
        return this.tripleMap.find(m).andThen(this.fragmentsMap.find(m));
    }

    public ExtendedIterator findExposed(TripleMatch m) {
        return this.findEither(m, false);
    }

    public ExtendedIterator findEither(TripleMatch m, boolean showHidden) {
        return showHidden == this.concealing ? this.find(m) : NullIterator.instance;
    }

    public int size() {
        return this.concealing ? 0 : this.tripleMap.size() + this.fragmentsMap.size();
    }

    private void parentRemoveQuad(Node n, Triple t) {
        this.parent.delete(Triple.create(n, RDF.Nodes.type, RDF.Nodes.Statement));
        this.parent.delete(Triple.create(n, RDF.Nodes.subject, t.getSubject()));
        this.parent.delete(Triple.create(n, RDF.Nodes.predicate, t.getPredicate()));
        this.parent.delete(Triple.create(n, RDF.Nodes.object, t.getObject()));
    }

    public static void graphAddQuad(GraphAdd g, Node node, Triple t) {
        g.add(Triple.create(node, RDF.Nodes.subject, t.getSubject()));
        g.add(Triple.create(node, RDF.Nodes.predicate, t.getPredicate()));
        g.add(Triple.create(node, RDF.Nodes.object, t.getObject()));
        g.add(Triple.create(node, RDF.Nodes.type, RDF.Nodes.Statement));
    }

    public String toString() {
        return "<R " + this.fragmentsMap + "|" + this.tripleMap + ">";
    }

    public void close() {
        this.fragmentsMap = null;
        this.tripleMap = null;
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

