/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.impl;

import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.graph.BulkUpdateHandler;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.GraphEventManager;
import mx.com.hp.hpl.jena.graph.GraphEvents;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.impl.GraphWithPerform;
import mx.com.hp.hpl.jena.util.IteratorCollection;

public class WrappedBulkUpdateHandler
implements BulkUpdateHandler {
    protected BulkUpdateHandler base;
    protected GraphEventManager manager;
    protected GraphWithPerform graph;

    public WrappedBulkUpdateHandler(GraphWithPerform graph, BulkUpdateHandler base) {
        this.graph = graph;
        this.base = base;
        this.manager = graph.getEventManager();
    }

    public void add(Triple[] triples) {
        this.base.add(triples);
        this.manager.notifyAddArray(this.graph, triples);
    }

    public void add(List triples) {
        this.base.add(triples);
        this.manager.notifyAddList(this.graph, triples);
    }

    public void add(Iterator it) {
        List s = IteratorCollection.iteratorToList(it);
        this.base.add(s);
        this.manager.notifyAddIterator((Graph)this.graph, s);
    }

    public void add(Graph g, boolean withReifications) {
        this.base.add(g, withReifications);
        this.manager.notifyAddGraph(this.graph, g);
    }

    public void add(Graph g) {
        this.base.add(g);
        this.manager.notifyAddGraph(this.graph, g);
    }

    public void delete(Triple[] triples) {
        this.base.delete(triples);
        this.manager.notifyDeleteArray(this.graph, triples);
    }

    public void delete(List triples) {
        this.base.delete(triples);
        this.manager.notifyDeleteList(this.graph, triples);
    }

    public void delete(Iterator it) {
        List s = IteratorCollection.iteratorToList(it);
        this.base.delete(s);
        this.manager.notifyDeleteIterator((Graph)this.graph, s);
    }

    public void delete(Graph g) {
        this.base.delete(g);
        this.manager.notifyDeleteGraph(this.graph, g);
    }

    public void delete(Graph g, boolean withReifications) {
        this.base.delete(g, withReifications);
        this.manager.notifyDeleteGraph(this.graph, g);
    }

    public void removeAll() {
        this.base.removeAll();
        this.manager.notifyEvent(this.graph, GraphEvents.removeAll);
    }

    public void remove(Node s, Node p, Node o) {
        this.base.remove(s, p, o);
        this.manager.notifyEvent(this.graph, GraphEvents.remove(s, p, o));
    }
}

