/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.impl;

import mx.com.hp.hpl.jena.graph.BulkUpdateHandler;
import mx.com.hp.hpl.jena.graph.Capabilities;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.GraphEventManager;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Reifier;
import mx.com.hp.hpl.jena.graph.TransactionHandler;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.TripleMatch;
import mx.com.hp.hpl.jena.graph.impl.GraphWithPerform;
import mx.com.hp.hpl.jena.graph.impl.SimpleEventManager;
import mx.com.hp.hpl.jena.graph.impl.WrappedBulkUpdateHandler;
import mx.com.hp.hpl.jena.graph.impl.WrappedReifier;
import mx.com.hp.hpl.jena.graph.query.QueryHandler;
import mx.com.hp.hpl.jena.shared.PrefixMapping;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class WrappedGraph
implements GraphWithPerform {
    protected Graph base;
    protected Reifier reifier;
    protected BulkUpdateHandler bud;
    protected GraphEventManager gem;

    public WrappedGraph(Graph base) {
        this.base = base;
        this.reifier = new WrappedReifier(base.getReifier(), this);
    }

    public boolean dependsOn(Graph other) {
        return this.base.dependsOn(other);
    }

    public QueryHandler queryHandler() {
        return this.base.queryHandler();
    }

    public TransactionHandler getTransactionHandler() {
        return this.base.getTransactionHandler();
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bud == null) {
            this.bud = new WrappedBulkUpdateHandler(this, this.base.getBulkUpdateHandler());
        }
        return this.bud;
    }

    public Capabilities getCapabilities() {
        return this.base.getCapabilities();
    }

    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new SimpleEventManager(this);
        }
        return this.gem;
    }

    public Reifier getReifier() {
        return this.reifier;
    }

    public PrefixMapping getPrefixMapping() {
        return this.base.getPrefixMapping();
    }

    public void add(Triple t) {
        this.base.add(t);
        this.getEventManager().notifyAddTriple(this, t);
    }

    public void delete(Triple t) {
        this.base.delete(t);
        this.getEventManager().notifyDeleteTriple(this, t);
    }

    public ExtendedIterator find(TripleMatch m) {
        return SimpleEventManager.notifyingRemove(this, this.base.find(m));
    }

    public ExtendedIterator find(Node s, Node p, Node o) {
        return SimpleEventManager.notifyingRemove(this, this.base.find(s, p, o));
    }

    public boolean isIsomorphicWith(Graph g) {
        return this.base.isIsomorphicWith(g);
    }

    public boolean contains(Node s, Node p, Node o) {
        return this.base.contains(s, p, o);
    }

    public boolean contains(Triple t) {
        return this.base.contains(t);
    }

    public void close() {
        this.base.close();
    }

    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    public int size() {
        return this.base.size();
    }

    public void performAdd(Triple t) {
        this.base.add(t);
    }

    public void performDelete(Triple t) {
        this.base.delete(t);
    }
}

