/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.query;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import java.util.NoSuchElementException;
import mx.com.hp.hpl.jena.graph.query.Domain;
import mx.com.hp.hpl.jena.graph.query.Pipe;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.shared.QueryStageException;

public class BufferPipe
implements Pipe {
    private boolean open = true;
    private BoundedBuffer buffer = new BoundedBuffer(5);
    private Object pending = null;
    private static final Finished finished = new Finished();

    private Object fetch() {
        try {
            return this.buffer.take();
        }
        catch (Exception e) {
            throw new BoundedBufferTakeException(e);
        }
    }

    private void putAny(Object d) {
        try {
            this.buffer.put(d);
            return;
        }
        catch (Exception e) {
            throw new BoundedBufferPutException(e);
        }
    }

    public void put(Domain d) {
        this.putAny(d);
    }

    public void close() {
        this.putAny(finished);
    }

    public void close(Exception e) {
        this.putAny(new Finished(e));
    }

    public boolean hasNext() {
        if (this.open) {
            if (this.pending == null) {
                this.pending = this.fetch();
                if (this.pending instanceof Finished) {
                    Finished end = (Finished)this.pending;
                    RuntimeException cause = end.getCause();
                    if (cause == null) {
                        this.open = false;
                    } else {
                        throw cause;
                    }
                }
                return this.open;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain get() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (!(this.pending instanceof Domain)) {
            throw new RuntimeException(this.pending.getClass().toString());
        }
        try {
            Domain domain = (Domain)this.pending;
            return domain;
        }
        finally {
            this.pending = null;
        }
    }

    public static class BoundedBufferPutException
    extends JenaException {
        BoundedBufferPutException(Exception e) {
            super(e);
        }
    }

    public static class BoundedBufferTakeException
    extends JenaException {
        BoundedBufferTakeException(Exception e) {
            super(e);
        }
    }

    public static class Finished {
        protected RuntimeException e;

        public Finished() {
        }

        public Finished(Exception e) {
            this.e = new QueryStageException(e);
        }

        public RuntimeException getCause() {
            return this.e;
        }
    }
}

