/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.query;

import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.IndexValues;
import mx.com.hp.hpl.jena.graph.query.Valuator;
import mx.com.hp.hpl.jena.graph.query.VariableIndexes;
import mx.com.hp.hpl.jena.shared.JenaException;

public abstract class Dyadic
extends Expression.Application {
    protected Expression L;
    protected Expression R;
    protected String F;

    public Dyadic(Expression L, String F, Expression R) {
        this.L = L;
        this.F = F;
        this.R = R;
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int i) {
        return i == 0 ? this.L : this.R;
    }

    public String getFun() {
        return this.F;
    }

    public Object evalObject(Object l, Object r) {
        return this.evalBool(l, r) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean evalBool(Object l, Object r) {
        Object x = this.evalObject(l, r);
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        throw new JenaException("not Boolean: " + x);
    }

    public Valuator prepare(VariableIndexes vi) {
        final Valuator l = this.L.prepare(vi);
        final Valuator r = this.R.prepare(vi);
        return new Valuator(){

            public boolean evalBool(IndexValues iv) {
                return (Boolean)this.evalObject(iv);
            }

            public Object evalObject(IndexValues iv) {
                return Dyadic.this.evalObject(l.evalObject(iv), r.evalObject(iv));
            }
        };
    }

    public String toString() {
        return this.L.toString() + " " + this.F + " " + this.R.toString();
    }

    public static Expression and(Expression L, Expression R) {
        return new Dyadic(L, "urn:x-jena:expr:AND", R){

            public boolean evalBool(Object x, Object y) {
                return (Boolean)x != false && (Boolean)y != false;
            }
        };
    }
}

