/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.query;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.query.Bind;
import mx.com.hp.hpl.jena.graph.query.Bound;
import mx.com.hp.hpl.jena.graph.query.Element;
import mx.com.hp.hpl.jena.graph.query.Fixed;
import mx.com.hp.hpl.jena.graph.query.Mapping;
import mx.com.hp.hpl.jena.graph.query.Pattern;
import mx.com.hp.hpl.jena.graph.query.PatternCompiler;
import mx.com.hp.hpl.jena.graph.query.Query;

public final class PatternStageCompiler
implements PatternCompiler {
    public static Pattern[] compile(PatternCompiler compiler, Mapping map, Triple[] source) {
        Pattern[] compiled = new Pattern[source.length];
        for (int i = 0; i < source.length; ++i) {
            compiled[i] = PatternStageCompiler.compile(compiler, source[i], map);
        }
        return compiled;
    }

    private static Pattern compile(PatternCompiler compiler, Triple t, Mapping map) {
        Node S = t.getSubject();
        Node P = t.getPredicate();
        Node O = t.getObject();
        return new Pattern(PatternStageCompiler.compile(compiler, S, map), PatternStageCompiler.compile(compiler, P, map), PatternStageCompiler.compile(compiler, O, map));
    }

    private static Element compile(PatternCompiler compiler, Node X, Mapping map) {
        if (X.equals(Query.ANY)) {
            return compiler.any();
        }
        if (X.isVariable()) {
            if (map.hasBound(X)) {
                return compiler.bound(X, map.indexOf(X));
            }
            return compiler.bind(X, map.newIndex(X));
        }
        return compiler.fixed(X);
    }

    public Element fixed(Node value) {
        return new Fixed(value);
    }

    public Element bound(Node n, int index) {
        return new Bound(index);
    }

    public Element bind(Node n, int index) {
        return new Bind(index);
    }

    public Element any() {
        return Element.ANY;
    }
}

