/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.query;

import java.util.Set;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.query.BindingQueryPlan;
import mx.com.hp.hpl.jena.graph.query.ExpressionSet;
import mx.com.hp.hpl.jena.graph.query.Mapping;
import mx.com.hp.hpl.jena.graph.query.PatternStage;
import mx.com.hp.hpl.jena.graph.query.Query;
import mx.com.hp.hpl.jena.graph.query.QueryHandler;
import mx.com.hp.hpl.jena.graph.query.SimpleQueryPlan;
import mx.com.hp.hpl.jena.graph.query.SimpleTreeQueryPlan;
import mx.com.hp.hpl.jena.graph.query.Stage;
import mx.com.hp.hpl.jena.graph.query.TreeQueryPlan;
import mx.com.hp.hpl.jena.util.CollectionFactory;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.WrappedIterator;

public class SimpleQueryHandler
implements QueryHandler {
    protected Graph graph;

    public SimpleQueryHandler(Graph graph) {
        this.graph = graph;
    }

    public Stage patternStage(Mapping map, ExpressionSet constraints, Triple[] t) {
        return new PatternStage(this.graph, map, constraints, t);
    }

    public BindingQueryPlan prepareBindings(Query q, Node[] variables) {
        return new SimpleQueryPlan(this.graph, q, variables);
    }

    public TreeQueryPlan prepareTree(Graph pattern) {
        return new SimpleTreeQueryPlan(this.graph, pattern);
    }

    public ExtendedIterator objectsFor(Node s, Node p) {
        return SimpleQueryHandler.objectsFor(this.graph, s, p);
    }

    public ExtendedIterator subjectsFor(Node p, Node o) {
        return SimpleQueryHandler.subjectsFor(this.graph, p, o);
    }

    public ExtendedIterator predicatesFor(Node s, Node o) {
        return SimpleQueryHandler.predicatesFor(this.graph, s, o);
    }

    public static ExtendedIterator objectsFor(Graph g, Node s, Node p) {
        Set objects = CollectionFactory.createHashedSet();
        ExtendedIterator it = g.find(s, p, Node.ANY);
        while (it.hasNext()) {
            objects.add(((Triple)it.next()).getObject());
        }
        return WrappedIterator.createNoRemove(objects.iterator());
    }

    public static ExtendedIterator subjectsFor(Graph g, Node p, Node o) {
        Set objects = CollectionFactory.createHashedSet();
        ExtendedIterator it = g.find(Node.ANY, p, o);
        while (it.hasNext()) {
            objects.add(((Triple)it.next()).getSubject());
        }
        return WrappedIterator.createNoRemove(objects.iterator());
    }

    public static ExtendedIterator predicatesFor(Graph g, Node s, Node o) {
        Set predicates = CollectionFactory.createHashedSet();
        ExtendedIterator it = g.find(s, Node.ANY, o);
        while (it.hasNext()) {
            predicates.add(((Triple)it.next()).getPredicate());
        }
        return WrappedIterator.createNoRemove(predicates.iterator());
    }

    public boolean containsNode(Node n) {
        return this.graph.contains(n, Node.ANY, Node.ANY) || this.graph.contains(Node.ANY, n, Node.ANY) || this.graph.contains(Node.ANY, Node.ANY, n);
    }
}

