/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.query;

import java.util.Iterator;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Factory;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.GraphUtil;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.query.TreeQueryPlan;
import mx.com.hp.hpl.jena.util.CollectionFactory;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class SimpleTreeQueryPlan
implements TreeQueryPlan {
    private Graph pattern;
    private Graph target;

    public SimpleTreeQueryPlan(Graph target, Graph pattern) {
        this.target = target;
        this.pattern = pattern;
    }

    public Graph executeTree() {
        Graph result = Factory.createGraphMem();
        Set roots = SimpleTreeQueryPlan.getRoots(this.pattern);
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            this.handleRoot(result, (Node)it.next(), CollectionFactory.createHashedSet());
        }
        return result;
    }

    private Iterator findFromTriple(Graph g, Triple t) {
        return g.find(this.asPattern(t.getSubject()), this.asPattern(t.getPredicate()), this.asPattern(t.getObject()));
    }

    private Node asPattern(Node x) {
        return x.isBlank() ? null : x;
    }

    private void handleRoot(Graph result, Node root, Set pending) {
        ExtendedIterator it = this.pattern.find(root, null, null);
        if (!it.hasNext()) {
            this.absorb(result, pending);
            return;
        }
        while (it.hasNext()) {
            Triple base = (Triple)it.next();
            Iterator that = this.findFromTriple(this.target, base);
            while (that.hasNext()) {
                Triple x = (Triple)that.next();
                pending.add(x);
                this.handleRoot(result, base.getObject(), pending);
            }
        }
    }

    private void absorb(Graph result, Set triples) {
        Iterator it = triples.iterator();
        while (it.hasNext()) {
            result.add((Triple)it.next());
        }
        triples.clear();
    }

    public static Set getRoots(Graph pattern) {
        Set roots = CollectionFactory.createHashedSet();
        ExtendedIterator sub = GraphUtil.findAll(pattern);
        while (sub.hasNext()) {
            roots.add(((Triple)sub.next()).getSubject());
        }
        ExtendedIterator obj = GraphUtil.findAll(pattern);
        while (obj.hasNext()) {
            roots.remove(((Triple)obj.next()).getObject());
        }
        return roots;
    }
}

