/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.query.regexptrees;

import java.util.ArrayList;
import mx.com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;
import mx.com.hp.hpl.jena.graph.query.regexptrees.RegexpTreeGenerator;
import mx.com.hp.hpl.jena.graph.query.regexptrees.SimpleGenerator;
import mx.com.hp.hpl.jena.graph.query.regexptrees.Text;

public class PerlPatternParser {
    protected final String toParse;
    protected int pointer;
    protected final int limit;
    protected RegexpTreeGenerator generator;
    protected int matchPointsSeen;
    public static final String digits = "0123456789";
    public static final String wordChars = "0123456789abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public PerlPatternParser(String toParse) {
        this(toParse, new SimpleGenerator());
    }

    public PerlPatternParser(String toParse, RegexpTreeGenerator gen) {
        this.toParse = toParse;
        this.limit = toParse.length();
        this.generator = gen;
    }

    public static RegexpTree parse(String string) {
        return new PerlPatternParser(string).parseAlts();
    }

    public static RegexpTree parse(String string, RegexpTreeGenerator gen) {
        return new PerlPatternParser(string, gen).parseAlts();
    }

    public String getString() {
        return this.toParse;
    }

    public int getPointer() {
        return this.pointer;
    }

    protected char nextChar() {
        return this.toParse.charAt(this.pointer++);
    }

    public RegexpTree parseAtom() {
        if (this.pointer < this.limit) {
            char ch = this.nextChar();
            switch (ch) {
                case '.': {
                    return this.generator.getAnySingle();
                }
                case '^': {
                    return this.generator.getStartOfLine();
                }
                case '$': {
                    return this.generator.getEndOfLine();
                }
                case '|': {
                    --this.pointer;
                    return this.generator.getNothing();
                }
                case '[': {
                    return this.parseClass();
                }
                case ')': {
                    --this.pointer;
                    return this.generator.getNothing();
                }
                case '(': {
                    return this.parseParens();
                }
                case '\\': {
                    return this.parseBackslash();
                }
                case '*': 
                case '+': 
                case '?': 
                case '{': {
                    throw new SyntaxException("unbound quantifier " + ch);
                }
            }
            return this.generator.getText(ch);
        }
        return this.generator.getNothing();
    }

    protected RegexpTree parseClass() {
        int ch;
        StringBuffer b = new StringBuffer();
        boolean negated = this.parseClassNegation();
        while ((ch = this.nextClassChar()) != 93) {
            if (ch == 45 && b.length() > 0) {
                char begin = (char)(b.charAt(b.length() - 1) + '\u0001');
                char end = (char)Math.abs(this.nextClassChar());
                for (char i = begin; i <= end; i = (char)(i + '\u0001')) {
                    b.append(i);
                }
                continue;
            }
            b.append((char)Math.abs(ch));
        }
        ++this.pointer;
        return this.generator.getClass(b.toString(), negated);
    }

    private int nextClassChar() {
        char ch = this.nextChar();
        if (ch == '\\') {
            RegexpTree t = this.parseAtom();
            if (t instanceof Text) {
                return -((Text)t).getString().charAt(0);
            }
            throw new SyntaxException("not allowed in class");
        }
        return ch;
    }

    protected boolean parseClassNegation() {
        if (this.toParse.charAt(this.pointer) == '^') {
            ++this.pointer;
            return true;
        }
        return false;
    }

    protected RegexpTree parseParens() {
        RegexpTree operand = this.parseAlts();
        if (this.pointer < this.limit && this.toParse.charAt(this.pointer) == ')') {
            ++this.pointer;
        } else {
            throw new SyntaxException("missing closing bracket");
        }
        ++this.matchPointsSeen;
        return this.generator.getParen(operand, this.matchPointsSeen);
    }

    private RegexpTree parseBackslash() {
        char ch = this.nextChar();
        if ("bBAZnrtfdDwWSsxc0123456789".indexOf(ch) < 0) {
            return this.generator.getText(ch);
        }
        if (ch == 'n') {
            return this.generator.getText('\n');
        }
        if (ch == 'r') {
            return this.generator.getText('\r');
        }
        if (ch == 'f') {
            return this.generator.getText('\f');
        }
        if (ch == 't') {
            return this.generator.getText('\t');
        }
        if (ch == 's') {
            return this.generator.getClass(" \r\n\t\f", false);
        }
        if (ch == 'S') {
            return this.generator.getClass(" \r\n\t\f", true);
        }
        if (ch == 'd') {
            return this.generator.getClass(digits, false);
        }
        if (ch == 'D') {
            return this.generator.getClass(digits, true);
        }
        if (ch == 'w') {
            return this.generator.getClass(wordChars, false);
        }
        if (ch == 'W') {
            return this.generator.getClass(wordChars, true);
        }
        if ('0' <= ch && ch <= '9') {
            return this.backReferenceOrOctalChar(ch);
        }
        if (ch == 'x') {
            return this.hexEscape();
        }
        if (ch == 'c') {
            return this.control(this.nextChar());
        }
        throw new SyntaxException("can't do \\" + ch + " yet");
    }

    protected RegexpTree control(char ch) {
        return Text.create((char)(ch - 65 + 1));
    }

    protected RegexpTree hexEscape() {
        char hi = this.nextChar();
        char lo = this.nextChar();
        return Text.create((char)(this.deHex(hi) * 16 + this.deHex(lo)));
    }

    private int deHex(char ch) {
        if (Character.isDigit(ch)) {
            return ch - 48;
        }
        if ('a' <= ch && ch <= 'f') {
            return 10 + ch - 97;
        }
        if ('A' <= ch && ch <= 'F') {
            return 10 + ch - 65;
        }
        throw new SyntaxException("'" + ch + "' is not a hex digit");
    }

    protected RegexpTree backReferenceOrOctalChar(char ch) {
        char[] chars = new char[20];
        int index = 0;
        chars[index++] = ch;
        while (this.pointer < this.limit && Character.isDigit(ch = this.nextChar())) {
            chars[index++] = ch;
        }
        char n = this.numeric(chars, 10, index);
        return '\u0000' < n && n <= this.matchPointsSeen ? this.generator.getBackReference(n) : this.generator.getText(this.numeric(chars, 8, index));
    }

    protected char numeric(char[] chars, int base, int limit) {
        int result = 0;
        for (int i = 0; i < limit; ++i) {
            result = result * base + (chars[i] - 48);
        }
        return (char)result;
    }

    public RegexpTree parseQuantifier(RegexpTree d) {
        if (this.pointer < this.limit) {
            char ch = this.toParse.charAt(this.pointer);
            switch (ch) {
                case '*': {
                    ++this.pointer;
                    return this.generator.getZeroOrMore(d);
                }
                case '+': {
                    ++this.pointer;
                    return this.generator.getOneOrMore(d);
                }
                case '?': {
                    ++this.pointer;
                    return this.generator.getOptional(d);
                }
                case '{': {
                    throw new SyntaxException("numeric quantifiers not done yet");
                }
            }
        }
        return d;
    }

    public RegexpTree parseElement() {
        return this.parseQuantifier(this.parseAtom());
    }

    public RegexpTree parseSeq() {
        RegexpTree next;
        ArrayList<RegexpTree> operands = new ArrayList<RegexpTree>();
        while (!(next = this.parseElement()).equals(this.generator.getNothing())) {
            operands.add(next);
        }
        return this.generator.getSequence(operands);
    }

    public RegexpTree parseAlts() {
        ArrayList<RegexpTree> operands = new ArrayList<RegexpTree>();
        while (true) {
            operands.add(this.parseSeq());
            if (this.pointer >= this.limit || this.toParse.charAt(this.pointer) != '|') break;
            ++this.pointer;
        }
        return this.generator.getAlternatives(operands);
    }

    public static class SyntaxException
    extends RuntimeException {
        public SyntaxException(String message) {
            super(message);
        }
    }
}

