/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.graph.query.regexptrees;

import java.util.List;
import mx.com.hp.hpl.jena.graph.query.regexptrees.Alternatives;
import mx.com.hp.hpl.jena.graph.query.regexptrees.AnyOf;
import mx.com.hp.hpl.jena.graph.query.regexptrees.BackReference;
import mx.com.hp.hpl.jena.graph.query.regexptrees.NoneOf;
import mx.com.hp.hpl.jena.graph.query.regexptrees.OneOrMore;
import mx.com.hp.hpl.jena.graph.query.regexptrees.Optional;
import mx.com.hp.hpl.jena.graph.query.regexptrees.Paren;
import mx.com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;
import mx.com.hp.hpl.jena.graph.query.regexptrees.RegexpTreeGenerator;
import mx.com.hp.hpl.jena.graph.query.regexptrees.Sequence;
import mx.com.hp.hpl.jena.graph.query.regexptrees.Text;
import mx.com.hp.hpl.jena.graph.query.regexptrees.ZeroOrMore;

public class SimpleGenerator
implements RegexpTreeGenerator {
    public RegexpTree getAnySingle() {
        return RegexpTree.ANY;
    }

    public RegexpTree getStartOfLine() {
        return RegexpTree.SOL;
    }

    public RegexpTree getEndOfLine() {
        return RegexpTree.EOL;
    }

    public RegexpTree getNothing() {
        return RegexpTree.NON;
    }

    public RegexpTree getText(char ch) {
        return Text.create(ch);
    }

    public RegexpTree getZeroOrMore(RegexpTree d) {
        return new ZeroOrMore(d);
    }

    public RegexpTree getOneOrMore(RegexpTree d) {
        return new OneOrMore(d);
    }

    public RegexpTree getOptional(RegexpTree d) {
        return new Optional(d);
    }

    public RegexpTree getSequence(List operands) {
        return Sequence.create(operands);
    }

    public RegexpTree getAlternatives(List operands) {
        return Alternatives.create(operands);
    }

    public RegexpTree getBackReference(int n) {
        return new BackReference(n);
    }

    public RegexpTree getClass(String chars, boolean reject) {
        return reject ? new NoneOf(chars) : new AnyOf(chars);
    }

    public RegexpTree getParen(RegexpTree operand, int index) {
        return new Paren(operand, index);
    }
}

